/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.spi;

import jakarta.inject.Provider;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

final class OnceProvider<T>
implements Provider<T> {
    private final ReentrantLock lock = new ReentrantLock();
    private final Provider<T> provider;
    private T bean;

    OnceProvider(Provider<T> provider) {
        this.provider = Objects.requireNonNull(provider);
    }

    public T get() {
        if (this.bean != null) {
            return this.bean;
        }
        this.lock.lock();
        try {
            if (this.bean == null) {
                this.bean = this.provider.get();
            }
            T t = this.bean;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }
}

