/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.spi;

import io.avaje.inject.spi.RawType;
import jakarta.inject.Named;
import java.lang.reflect.Type;
import java.util.function.Consumer;
import org.mockito.Mockito;

public class SuppliedBean {
    private static final Class<?>[] NO_INTERFACES = new Class[0];
    private final String name;
    private final Type type;
    private final int priority;
    protected Object source;

    public static SuppliedBean of(Class<?> type, Object source) {
        return new ForClass(null, type, source, null);
    }

    public static <B> SuppliedBean of(String name, Class<B> type, Consumer<B> consumer) {
        return new ForClass<B>(name, type, null, consumer);
    }

    public static <B> SuppliedBean of(String name, Class<B> type, B source) {
        return new ForClass<B>(name, type, source, null);
    }

    public static SuppliedBean ofType(String name, Type type, Object source) {
        return new ForType(name, type, source);
    }

    public static SuppliedBean secondary(String name, Type type, Object source) {
        return new SuppliedBean(Integer.MAX_VALUE, name, type, source);
    }

    private SuppliedBean(int priority, String name, Type type, Object source) {
        this.priority = priority;
        this.name = name;
        this.type = type;
        this.source = source;
    }

    public Object source() {
        return this.source;
    }

    public final int priority() {
        return this.priority;
    }

    public final Type type() {
        return this.type;
    }

    public final String name() {
        if (this.name != null) {
            return this.name;
        }
        if (this.type instanceof Class) {
            Named annotation = ((Class)this.type).getAnnotation(Named.class);
            return annotation == null ? null : annotation.value();
        }
        return null;
    }

    public final Class<?>[] interfaces() {
        if (this.type instanceof Class) {
            return ((Class)this.type).getInterfaces();
        }
        return NO_INTERFACES;
    }

    private static final class ForClass<B>
    extends SuppliedBean {
        private final Consumer<B> consumer;
        private final Class<B> classType;

        ForClass(String name, Class<B> type, Object source, Consumer<B> consumer) {
            super(Integer.MIN_VALUE, name, type, source);
            this.classType = type;
            this.consumer = consumer;
        }

        @Override
        public Object source() {
            if (this.source == null) {
                Object mock = Mockito.mock(this.classType);
                if (this.consumer != null) {
                    this.consumer.accept(mock);
                }
                this.source = mock;
            }
            return this.source;
        }
    }

    private static final class ForType
    extends SuppliedBean {
        private final Type classType;

        ForType(String name, Type type, Object source) {
            super(Integer.MIN_VALUE, name, type, source);
            this.classType = type;
        }

        @Override
        public Object source() {
            if (this.source == null) {
                this.source = Mockito.mock(RawType.of(this.classType));
            }
            return this.source;
        }
    }
}

