/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.aop;

import io.avaje.inject.aop.MethodInterceptor;
import java.lang.reflect.Method;
import java.util.Arrays;

public interface Invocation {
    public Object invoke() throws Throwable;

    public void result(Object var1);

    public Object[] arguments();

    public Object[] arguments(Throwable var1);

    public Method method();

    public Object instance();

    @FunctionalInterface
    public static interface CheckedSupplier<T> {
        public T invoke() throws Throwable;
    }

    @FunctionalInterface
    public static interface CheckedRunnable {
        public void invoke() throws Throwable;
    }

    public static final class Call<T>
    extends Build<T> {
        private final CheckedSupplier<T> delegate;

        public Call(CheckedSupplier<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke() throws Throwable {
            this.result = this.delegate.invoke();
            return this.result;
        }

        @Override
        public T finalResult() {
            return (T)this.result;
        }

        @Override
        public Build<T> wrap(MethodInterceptor methodInterceptor) {
            return new Call<Object>(() -> {
                Call delegate = this;
                methodInterceptor.invoke(delegate);
                return delegate.finalResult();
            }).with(this.instance, this.method, this.args);
        }
    }

    public static final class Run
    extends Build<Void> {
        private final CheckedRunnable delegate;

        public Run(CheckedRunnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke() throws Throwable {
            this.delegate.invoke();
            return null;
        }

        @Override
        public Build<Void> wrap(MethodInterceptor methodInterceptor) {
            return new Run(() -> methodInterceptor.invoke(this)).with(this.instance, this.method, this.args);
        }
    }

    public static abstract class Build<T>
    implements Invocation {
        protected Method method;
        protected Object[] args;
        protected Object instance;
        protected T result;

        public Build<T> with(Object instance, Method method, Object ... args) {
            this.instance = instance;
            this.method = method;
            this.args = args;
            return this;
        }

        @Override
        public void result(Object result) {
            this.result = result;
        }

        public T finalResult() {
            return this.result;
        }

        @Override
        public Object[] arguments() {
            return this.args;
        }

        @Override
        public Object[] arguments(Throwable e) {
            if (this.args == null || this.args.length == 0) {
                return new Object[]{e};
            }
            Object[] newArgs = Arrays.copyOf(this.args, this.args.length + 1);
            newArgs[this.args.length] = e;
            return newArgs;
        }

        @Override
        public Method method() {
            return this.method;
        }

        @Override
        public Object instance() {
            return this.instance;
        }

        public abstract Build<T> wrap(MethodInterceptor var1);
    }
}

