/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.spi;

import io.avaje.inject.spi.DEntry;
import io.avaje.inject.spi.KeyUtil;
import jakarta.inject.Provider;
import java.util.Objects;

class DContextEntryBean {
    protected final Object source;
    protected final String name;
    private final int flag;

    static DContextEntryBean of(Object bean, String name, int flag) {
        if (bean instanceof Provider) {
            return new Prov((Provider)bean, name, flag);
        }
        return new DContextEntryBean(bean, name, flag);
    }

    static DContextEntryBean provider(Provider<?> provider, String name, int flag) {
        return new Prov(provider, name, flag);
    }

    private DContextEntryBean(Object source, String name, int flag) {
        this.source = source;
        this.name = KeyUtil.lower(name);
        this.flag = flag;
    }

    public final String toString() {
        return "Bean{source=" + this.source + ", name='" + this.name + "', flag=" + this.flag + "}";
    }

    final DEntry entry() {
        return new DEntry(this.name, this.flag, this.bean());
    }

    final boolean isNameMatch(String qualifierName) {
        return qualifierName == null || qualifierName.equals(this.name);
    }

    final boolean isNameEqual(String qualifierName) {
        return Objects.equals(qualifierName, this.name);
    }

    Object beanIfNameMatch(String name) {
        return this.isNameMatch(name) ? this.bean() : null;
    }

    String name() {
        return this.name;
    }

    Object bean() {
        return this.source;
    }

    Provider<?> provider() {
        return this::bean;
    }

    final boolean isPrimary() {
        return this.flag == 1;
    }

    final boolean isSecondary() {
        return this.flag == -1;
    }

    final boolean isSupplied() {
        return this.flag == 2;
    }

    final boolean isSupplied(String qualifierName) {
        return this.flag == 2 && (qualifierName == null || qualifierName.equals(this.name));
    }

    static final class Prov
    extends DContextEntryBean {
        private final Provider<?> provider;

        private Prov(Provider<?> provider, String name, int flag) {
            super(provider, name, flag);
            this.provider = provider;
        }

        @Override
        Provider<?> provider() {
            return this.provider;
        }

        @Override
        Object bean() {
            return this.provider.get();
        }
    }
}

