/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.spi;

import io.avaje.inject.BeanEntry;
import io.avaje.lang.NonNullApi;
import java.util.LinkedHashSet;
import java.util.Set;

@NonNullApi
class DEntry
implements BeanEntry {
    private final String qualifierName;
    private final int priority;
    private final Object bean;
    private final Set<String> keys = new LinkedHashSet<String>();

    DEntry(String qualifierName, int priority, Object bean) {
        this.qualifierName = qualifierName;
        this.priority = priority;
        this.bean = bean;
    }

    public String toString() {
        return "{bean=" + this.bean + (String)(this.qualifierName == null ? "" : ", name='" + this.qualifierName + "'") + (String)(this.keys.isEmpty() ? "" : ", keys=" + this.keys) + ", priority=" + this.priority + "}";
    }

    void addKey(String key) {
        this.keys.add(key);
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public Object bean() {
        return this.bean;
    }

    @Override
    public Class<?> type() {
        return this.bean.getClass();
    }

    @Override
    public String qualifierName() {
        return this.qualifierName;
    }

    @Override
    public Set<String> keys() {
        return this.keys;
    }

    @Override
    public boolean hasKey(Class<?> type) {
        return this.keys.contains(type.getTypeName());
    }
}

