/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.spi;

import io.avaje.inject.spi.KeyUtil;
import java.util.function.Consumer;
import org.mockito.Mockito;

public class EnrichBean<B> {
    private final Class<B> type;
    private final String name;
    private final Consumer<B> consumer;

    public EnrichBean(Class<B> type, String name, Consumer<B> consumer) {
        this.type = type;
        this.name = KeyUtil.lower(name);
        this.consumer = consumer;
    }

    public B enrich(B bean) {
        Object spy = Mockito.spy(bean);
        if (this.consumer != null) {
            this.consumer.accept(spy);
        }
        return (B)spy;
    }

    public String key() {
        return KeyUtil.key(this.type, this.name);
    }
}

