/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.spi;

import jakarta.inject.Named;
import java.lang.reflect.Type;
import java.util.function.Consumer;
import org.mockito.Mockito;

public abstract class SuppliedBean<B> {
    protected final String name;
    protected final Type type;
    protected B bean;

    public static SuppliedBean of(Class<?> type, Object bean) {
        return new ForClass<Object>(null, type, bean, null);
    }

    public static <B> SuppliedBean<B> of(String name, Class<B> type, B bean, Consumer<B> consumer) {
        return new ForClass<B>(name, type, bean, consumer);
    }

    public static <B> SuppliedBean<B> of(String name, Class<B> type, B bean) {
        return new ForClass<B>(name, type, bean, null);
    }

    public static <B> SuppliedBean<B> ofType(String name, Type type, B bean) {
        return new ForType<B>(name, type, bean);
    }

    private SuppliedBean(String name, Type type, B bean) {
        this.name = name;
        this.type = type;
        this.bean = bean;
    }

    private SuppliedBean(String name, Class<B> type, B bean) {
        this.name = this.initName(name, type);
        this.type = type;
        this.bean = bean;
    }

    String initName(String name, Class<?> type) {
        if (name != null) {
            return name;
        }
        Named annotation = type.getAnnotation(Named.class);
        return annotation == null ? null : annotation.value();
    }

    public Type type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public abstract B bean();

    public abstract Class<?>[] interfaces();

    private static class ForClass<B>
    extends SuppliedBean<B> {
        private final Consumer<B> consumer;
        private final Class<B> classType;

        ForClass(String name, Class<B> type, B bean, Consumer<B> consumer) {
            super(name, type, bean);
            this.classType = type;
            this.consumer = consumer;
        }

        @Override
        public B bean() {
            if (this.bean == null) {
                this.bean = Mockito.mock(this.classType);
            }
            if (this.consumer != null) {
                this.consumer.accept(this.bean);
            }
            return (B)this.bean;
        }

        @Override
        public Class<?>[] interfaces() {
            return this.classType.getInterfaces();
        }
    }

    private static class ForType<B>
    extends SuppliedBean<B> {
        private ForType(String name, Type type, B bean) {
            super(name, type, bean);
        }

        @Override
        public B bean() {
            return (B)this.bean;
        }

        @Override
        public Class<?>[] interfaces() {
            return new Class[0];
        }
    }
}

