/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.spi;

import io.avaje.inject.BeanScope;
import io.avaje.inject.spi.Builder;
import io.avaje.inject.spi.DBeanMap;
import io.avaje.inject.spi.DBeanScope;
import io.avaje.inject.spi.DBeanScopeProxy;
import io.avaje.inject.spi.PropertyRequiresPlugin;
import io.avaje.inject.spi.ProviderPromise;
import jakarta.inject.Provider;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

class DBuilder
implements Builder {
    private final PropertyRequiresPlugin propertyRequires;
    private final List<Runnable> postConstruct = new ArrayList<Runnable>();
    private final List<AutoCloseable> preDestroy = new ArrayList<AutoCloseable>();
    private final List<Consumer<Builder>> injectors = new ArrayList<Consumer<Builder>>();
    protected final DBeanMap beanMap = new DBeanMap();
    protected final BeanScope parent;
    protected final boolean parentOverride;
    protected Object parentMatch;
    private Type injectTarget;
    private boolean runningPostConstruct;
    private DBeanScopeProxy beanScopeProxy;

    DBuilder(PropertyRequiresPlugin propertyRequires, BeanScope parent, boolean parentOverride) {
        this.propertyRequires = propertyRequires;
        this.parent = parent;
        this.parentOverride = parentOverride;
    }

    @Override
    public final boolean isAddBeanFor(Type ... types) {
        return this.isAddBeanFor((String)null, types);
    }

    @Override
    public boolean isAddBeanFor(String name, Type ... types) {
        this.parentMatch = null;
        this.next(name, types);
        if (this.parentOverride || this.parent == null) {
            return true;
        }
        if (this.parent instanceof DBeanScope) {
            DBeanScope dParent = (DBeanScope)this.parent;
            this.parentMatch = dParent.getStrict(name, this.removeAnnotations(types));
            return this.parentMatch == null;
        }
        return true;
    }

    protected final Type[] removeAnnotations(Type[] source) {
        int end = source.length;
        for (int i = 1; i < end; ++i) {
            if (!this.isAnnotationType(source[i])) continue;
            return Arrays.copyOf(source, i);
        }
        return source;
    }

    private boolean isAnnotationType(Type type) {
        return type instanceof Class && ((Class)type).isAnnotation();
    }

    protected final void next(String name, Type ... types) {
        this.injectTarget = this.firstOf(types);
        this.beanMap.nextBean(name, types);
    }

    private Type firstOf(Type[] types) {
        return types != null && types.length > 0 ? types[0] : null;
    }

    @Override
    public final <T> Set<T> set(Class<T> type) {
        return new LinkedHashSet<T>(this.listOf(type));
    }

    @Override
    public final <T> List<T> list(Class<T> type) {
        return this.listOf(type);
    }

    @Override
    public final <T> Set<T> set(Type type) {
        return new LinkedHashSet<T>(this.listOf(type));
    }

    @Override
    public final <T> List<T> list(Type type) {
        return this.listOf(type);
    }

    private <T> List<T> listOf(Type type) {
        List<Object> values = this.beanMap.all(type);
        if (this.parent == null) {
            return values;
        }
        return DBeanScope.combine(values, this.parent.list(type));
    }

    @Override
    public final <T> Map<String, T> map(Class<T> type) {
        return this.mapOf(type);
    }

    @Override
    public final <T> Map<String, T> map(Type type) {
        return this.mapOf(type);
    }

    private <T> Map<String, T> mapOf(Type type) {
        return this.beanMap.map(type, this.parent);
    }

    private <T> T getMaybe(Type type, String name) {
        Object bean = this.beanMap.get(type, name);
        if (bean != null) {
            return bean;
        }
        return this.parent == null ? null : this.parent.getOptional(type, name).orElse(null);
    }

    protected <T> T enrich(T bean, DBeanMap.NextBean next) {
        return bean;
    }

    @Override
    public final <T> T register(T bean) {
        bean = this.enrich(bean, this.beanMap.next());
        this.beanMap.register(bean);
        return bean;
    }

    @Override
    public Builder asPrimary() {
        this.beanMap.nextPriority(1);
        return this;
    }

    @Override
    public Builder asSecondary() {
        this.beanMap.nextPriority(-1);
        return this;
    }

    @Override
    public Builder asPrototype() {
        this.beanMap.nextPrototype();
        return this;
    }

    @Override
    public final <T> void registerProvider(Provider<T> provider) {
        this.beanMap.register(provider);
    }

    @Override
    public final <T> void withBean(Class<T> type, T bean) {
        this.next(null, type);
        this.beanMap.nextPriority(2);
        this.beanMap.register(bean);
    }

    @Override
    public final void addPostConstruct(Runnable invoke) {
        this.postConstruct.add(invoke);
    }

    @Override
    public final void addPreDestroy(AutoCloseable invoke) {
        this.preDestroy.add(invoke);
    }

    @Override
    public final void addAutoClosable(Object maybeAutoCloseable) {
        if (maybeAutoCloseable instanceof AutoCloseable) {
            this.preDestroy.add((AutoCloseable)maybeAutoCloseable);
        }
    }

    @Override
    public final void addInjector(Consumer<Builder> injector) {
        this.injectors.add(injector);
    }

    @Override
    public final <T> Optional<T> getOptional(Class<T> type) {
        return this.optional(type, null);
    }

    @Override
    public final <T> Optional<T> getOptional(Class<T> type, String name) {
        return this.optional(type, name);
    }

    @Override
    public final <T> Optional<T> getOptional(Type type) {
        return this.optional(type, null);
    }

    @Override
    public final <T> Optional<T> getOptional(Type type, String name) {
        return this.optional(type, name);
    }

    private <T> Optional<T> optional(Type type, String name) {
        return Optional.ofNullable(this.getMaybe(type, name));
    }

    @Override
    public final <T> T getNullable(Class<T> type) {
        return this.getMaybe(type, null);
    }

    @Override
    public final <T> T getNullable(Class<T> type, String name) {
        return this.getMaybe(type, name);
    }

    @Override
    public final <T> T getNullable(Type type) {
        return this.getMaybe(type, null);
    }

    @Override
    public final <T> T getNullable(Type type, String name) {
        return this.getMaybe(type, name);
    }

    @Override
    public final <T> Provider<T> getProvider(Class<T> type) {
        return this.provider(type, null);
    }

    @Override
    public final <T> Provider<T> getProvider(Class<T> type, String name) {
        return this.provider(type, name);
    }

    @Override
    public final <T> Provider<T> getProvider(Type type) {
        return this.provider(type, null);
    }

    @Override
    public final <T> Provider<T> getProvider(Type type, String name) {
        return this.provider(type, name);
    }

    private <T> Provider<T> provider(Type type, String name) {
        if (this.runningPostConstruct) {
            return this.obtainProvider(type, name);
        }
        ProviderPromise promise = new ProviderPromise(type, name, this);
        this.injectors.add(promise);
        return promise;
    }

    <T> Provider<T> obtainProvider(Type type, String name) {
        Provider provider = this.beanMap.provider(type, name);
        if (provider != null) {
            return provider;
        }
        return () -> this.get(type, name);
    }

    @Override
    public final <T> Provider<T> getProviderFor(Class<?> cls, Type type) {
        return () -> {
            Object bean = this.getMaybe(cls, null);
            if (bean == null) {
                bean = this.getMaybe(type, null);
            }
            if (bean != null) {
                return bean;
            }
            String msg = "Unable to inject an instance for generic type " + type + " usually provided by " + cls + "?";
            throw new IllegalStateException(msg);
        };
    }

    @Override
    public final <T> T get(Class<T> type) {
        return this.getBean(type, null);
    }

    @Override
    public final <T> T get(Class<T> type, String name) {
        return this.getBean(type, name);
    }

    @Override
    public final <T> T get(Type type) {
        return this.getBean(type, null);
    }

    @Override
    public final <T> T get(Type type, String name) {
        return this.getBean(type, name);
    }

    @Override
    public boolean contains(String type) {
        return this.beanMap.contains(type);
    }

    @Override
    public boolean contains(Type type) {
        return this.beanMap.contains(type);
    }

    @Override
    public boolean containsQualifier(String name) {
        return this.beanMap.containsQualifier(name);
    }

    @Override
    public PropertyRequiresPlugin property() {
        return this.propertyRequires;
    }

    private <T> T getBean(Type type, String name) {
        if (BeanScope.class.equals((Object)type)) {
            return this.injectBeanScope();
        }
        T bean = this.getMaybe(type, name);
        if (bean == null) {
            throw new IllegalStateException(this.errorInjectingNull(type, name));
        }
        return bean;
    }

    private <T> T injectBeanScope() {
        if (this.beanScopeProxy == null) {
            this.beanScopeProxy = new DBeanScopeProxy(this);
        }
        return (T)this.beanScopeProxy;
    }

    private <T> String errorInjectingNull(Type type, String name) {
        String msg = "Injecting null for " + type.getTypeName();
        if (name != null) {
            msg = msg + " name:" + name;
        }
        List<T> beanList = this.list(type);
        msg = msg + " when creating " + this.injectTarget + " - potential beans to inject: " + beanList;
        if (!beanList.isEmpty()) {
            msg = msg + ". Check @Named or Qualifier being used";
        }
        msg = msg + ". Check for missing module? [ missing beanScopeBuilder.modules() ]";
        msg = msg + ". If it is expected to be externally provided, missing beanScopeBuilder.bean() ?";
        return msg;
    }

    private void runInjectors() {
        this.runningPostConstruct = true;
        for (Consumer<Builder> injector : this.injectors) {
            injector.accept(this);
        }
    }

    @Override
    public final BeanScope build(boolean withShutdownHook, long start) {
        this.runInjectors();
        DBeanScope scope = new DBeanScope(withShutdownHook, this.preDestroy, this.postConstruct, this.beanMap, this.parent);
        if (this.beanScopeProxy != null) {
            this.beanScopeProxy.inject(scope);
        }
        return scope.start(start);
    }
}

