/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.core;

import io.avaje.json.JsonAdapter;
import io.avaje.json.JsonReader;
import io.avaje.json.JsonWriter;
import io.avaje.json.view.ViewBuilder;
import io.avaje.json.view.ViewBuilderAware;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

abstract class CollectionAdapter<C extends Collection<T>, T>
implements ViewBuilderAware,
JsonAdapter<C> {
    private final JsonAdapter<T> elementAdapter;

    static <T> JsonAdapter<List<T>> createList(JsonAdapter<T> elementAdapter) {
        return new CollectionAdapter<List<T>, T>((JsonAdapter)elementAdapter){

            @Override
            List<T> newCollection() {
                return new ArrayList();
            }
        };
    }

    static <T> JsonAdapter<Set<T>> createSet(JsonAdapter<T> elementAdapter) {
        return new CollectionAdapter<Set<T>, T>((JsonAdapter)elementAdapter){

            @Override
            Set<T> newCollection() {
                return new LinkedHashSet();
            }
        };
    }

    private CollectionAdapter(JsonAdapter<T> elementAdapter) {
        this.elementAdapter = elementAdapter;
    }

    abstract C newCollection();

    @Override
    public boolean isViewBuilderAware() {
        return this.elementAdapter.isViewBuilderAware();
    }

    @Override
    public ViewBuilderAware viewBuild() {
        return this;
    }

    @Override
    public void build(ViewBuilder builder, String name, MethodHandle handle) {
        builder.addArray(name, this.elementAdapter, handle);
    }

    @Override
    public C fromJson(JsonReader reader) {
        C result = this.newCollection();
        reader.beginArray();
        while (reader.hasNextElement()) {
            result.add(this.elementAdapter.fromJson(reader));
        }
        reader.endArray();
        return result;
    }

    @Override
    public void toJson(JsonWriter writer, C value) {
        if (value == null) {
            writer.nullValue();
            return;
        }
        if (value.isEmpty()) {
            writer.emptyArray();
            return;
        }
        writer.beginArray();
        for (Object element : value) {
            this.elementAdapter.toJson(writer, element);
        }
        writer.endArray();
    }

    public String toString() {
        return String.valueOf(this.elementAdapter) + ".collection()";
    }
}

