/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.mapper;

import io.avaje.json.mapper.JsonExtract;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

final class DExtract
implements JsonExtract {
    private static final Pattern PATH_PATTERN = Pattern.compile("\\.");
    private final Map<String, Object> map;

    DExtract(Map<String, Object> map) {
        this.map = map;
    }

    private Object find(String path, Map<String, Object> map) {
        String[] paths = PATH_PATTERN.split(path, 2);
        Object child = map.get(paths[0]);
        if (child == null || paths.length == 1) {
            return child;
        }
        if (child instanceof Map) {
            return this.find(paths[1], (Map)child);
        }
        return null;
    }

    @Override
    public String extract(String path) {
        Object node = this.find(path, this.map);
        if (node == null) {
            throw new IllegalArgumentException("Node not present for " + path);
        }
        return node.toString();
    }

    @Override
    public Optional<String> extractOrEmpty(String path) {
        Object name = this.find(path, this.map);
        return name == null ? Optional.empty() : Optional.of(name.toString());
    }

    @Override
    public String extract(String path, String missingValue) {
        Object name = this.find(path, this.map);
        return name == null ? missingValue : name.toString();
    }

    @Override
    public int extract(String path, int missingValue) {
        Object node = this.find(path, this.map);
        return !(node instanceof Number) ? missingValue : ((Number)node).intValue();
    }

    @Override
    public long extract(String path, long missingValue) {
        Object node = this.find(path, this.map);
        return !(node instanceof Number) ? missingValue : ((Number)node).longValue();
    }

    @Override
    public double extract(String path, double missingValue) {
        Object node = this.find(path, this.map);
        return !(node instanceof Number) ? missingValue : ((Number)node).doubleValue();
    }

    @Override
    public boolean extract(String path, boolean missingValue) {
        Object node = this.find(path, this.map);
        return !(node instanceof Boolean) ? missingValue : (Boolean)node;
    }
}

