/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.mapper;

import io.avaje.json.JsonAdapter;
import io.avaje.json.JsonException;
import io.avaje.json.JsonReader;
import io.avaje.json.JsonWriter;
import io.avaje.json.core.CoreTypes;
import io.avaje.json.mapper.JsonMapper;
import io.avaje.json.stream.BufferedJsonWriter;
import io.avaje.json.stream.BytesJsonWriter;
import io.avaje.json.stream.JsonStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;

final class DTypeMapper<T>
implements JsonMapper.Type<T> {
    private final JsonAdapter<T> adapter;
    private final JsonStream jsonStream;

    DTypeMapper(JsonAdapter<T> adapter, JsonStream jsonStream) {
        this.adapter = adapter;
        this.jsonStream = jsonStream;
    }

    @Override
    public JsonMapper.Type<List<T>> list() {
        JsonAdapter<List<T>> list = CoreTypes.createList(this.adapter);
        return new DTypeMapper<List<T>>(list, this.jsonStream);
    }

    @Override
    public JsonMapper.Type<Map<String, T>> map() {
        JsonAdapter<Map<String, T>> map = CoreTypes.createMap(this.adapter);
        return new DTypeMapper<Map<String, T>>(map, this.jsonStream);
    }

    @Override
    public T fromJson(JsonReader reader) {
        return this.adapter.fromJson(reader);
    }

    @Override
    public T fromJson(String content) {
        try (JsonReader reader = this.jsonStream.reader(content);){
            T t = this.adapter.fromJson(reader);
            return t;
        }
    }

    @Override
    public T fromJson(byte[] content) {
        try (JsonReader reader = this.jsonStream.reader(content);){
            T t = this.adapter.fromJson(reader);
            return t;
        }
    }

    @Override
    public T fromJson(Reader content) {
        try (JsonReader reader = this.jsonStream.reader(content);){
            T t = this.adapter.fromJson(reader);
            return t;
        }
    }

    @Override
    public T fromJson(InputStream content) {
        try (JsonReader reader = this.jsonStream.reader(content);){
            T t = this.adapter.fromJson(reader);
            return t;
        }
    }

    @Override
    public String toJson(T value) {
        try (BufferedJsonWriter writer = this.jsonStream.bufferedWriter();){
            this.toJson(value, writer);
            String string = writer.result();
            return string;
        }
    }

    @Override
    public String toJsonPretty(T value) {
        try (BufferedJsonWriter writer = this.jsonStream.bufferedWriter();){
            writer.pretty(true);
            this.toJson(value, writer);
            String string = writer.result();
            return string;
        }
    }

    @Override
    public byte[] toJsonBytes(T value) {
        try (BytesJsonWriter writer = this.jsonStream.bufferedWriterAsBytes();){
            this.toJson(value, writer);
            byte[] byArray = writer.result();
            return byArray;
        }
    }

    @Override
    public void toJson(T value, JsonWriter writer) {
        try {
            this.adapter.toJson(writer, value);
        }
        catch (RuntimeException e) {
            writer.markIncomplete();
            throw new JsonException(e);
        }
    }

    @Override
    public void toJson(T value, Writer writer) {
        try (JsonWriter jsonWriter = this.jsonStream.writer(writer);){
            this.toJson(value, jsonWriter);
        }
    }

    @Override
    public void toJson(T value, OutputStream outputStream) {
        try (JsonWriter writer = this.jsonStream.writer(outputStream);){
            this.toJson(value, writer);
        }
        this.close(outputStream);
    }

    private void close(Closeable outputStream) {
        try {
            outputStream.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error closing stream", e);
        }
    }
}

