/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.stream.core;

import io.avaje.json.JsonDataException;
import io.avaje.json.JsonReader;
import io.avaje.json.PropertyNames;
import io.avaje.json.stream.core.BufferRecycler;
import io.avaje.json.stream.core.JsonNames;
import io.avaje.json.stream.core.JsonParser;
import java.math.BigDecimal;
import java.math.BigInteger;

final class JsonReadAdapter
implements JsonReader {
    private final JsonParser reader;
    private final boolean failOnUnknown;
    private final boolean failOnNullPrimitives;
    private final BufferRecycler recycler;

    JsonReadAdapter(JsonParser reader, BufferRecycler recycler, boolean failOnUnknown, boolean failOnNullPrimitives) {
        this.reader = reader;
        this.failOnUnknown = failOnUnknown;
        this.failOnNullPrimitives = failOnNullPrimitives;
        this.recycler = recycler;
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        return type.cast(this.reader);
    }

    @Override
    public void beginStream() {
        this.reader.startStream();
    }

    @Override
    public void endStream() {
        this.reader.endStream();
    }

    @Override
    public void beginArray() {
        this.reader.startArray();
    }

    @Override
    public void endArray() {
        this.reader.endArray();
    }

    @Override
    public void beginObject(PropertyNames names) {
        this.reader.startObject((JsonNames)names);
    }

    @Override
    public void beginObject() {
        this.reader.startObject();
    }

    @Override
    public void endObject() {
        this.reader.endObject();
    }

    @Override
    public boolean hasNextElement() {
        return this.reader.hasNextElement();
    }

    @Override
    public boolean hasNextStreamElement() {
        return this.reader.hasNextStreamElement();
    }

    @Override
    public boolean hasNextField() {
        byte nextToken = this.reader.nextToken();
        if (nextToken == 34) {
            return true;
        }
        if (nextToken == 44) {
            return this.reader.nextToken() == 34;
        }
        return false;
    }

    @Override
    public String nextField() {
        return this.reader.nextField();
    }

    @Override
    public boolean readBoolean() {
        if (this.failOnNullPrimitives && this.reader.isNullValue()) {
            throw new JsonDataException("Read NULL value for boolean");
        }
        return this.reader.readBoolean();
    }

    @Override
    public int readInt() {
        if (this.failOnNullPrimitives && this.reader.isNullValue()) {
            throw new JsonDataException("Read NULL value for int");
        }
        return this.reader.readInt();
    }

    @Override
    public long readLong() {
        if (this.failOnNullPrimitives && this.reader.isNullValue()) {
            throw new JsonDataException("Read NULL value for long");
        }
        return this.reader.readLong();
    }

    @Override
    public double readDouble() {
        if (this.failOnNullPrimitives && this.reader.isNullValue()) {
            throw new JsonDataException("Read NULL value for double");
        }
        return this.reader.readDouble();
    }

    @Override
    public BigDecimal readDecimal() {
        return this.reader.readDecimal();
    }

    @Override
    public BigInteger readBigInteger() {
        return this.reader.readBigInteger();
    }

    @Override
    public String readString() {
        return this.reader.readString();
    }

    @Override
    public byte[] readBinary() {
        return this.reader.readBinary();
    }

    @Override
    public boolean isNullValue() {
        return this.reader.isNullValue();
    }

    @Override
    public String location() {
        return this.reader.location();
    }

    @Override
    public JsonReader.Token currentToken() {
        byte token = this.reader.currentToken();
        switch (token) {
            case 91: {
                return JsonReader.Token.BEGIN_ARRAY;
            }
            case 123: {
                return JsonReader.Token.BEGIN_OBJECT;
            }
            case 110: {
                return JsonReader.Token.NULL;
            }
            case 34: {
                return JsonReader.Token.STRING;
            }
            case 102: 
            case 116: {
                return JsonReader.Token.BOOLEAN;
            }
        }
        return JsonReader.Token.NUMBER;
    }

    @Override
    public void close() {
        this.reader.close();
        this.recycler.recycle(this.reader);
    }

    @Override
    public void skipValue() {
        this.reader.skipValue();
    }

    @Override
    public String readRaw() {
        return this.reader.readRaw();
    }

    @Override
    public void unmappedField(String fieldName) {
        if (this.failOnUnknown) {
            throw new IllegalStateException("Unknown property " + fieldName + " at " + this.reader.location());
        }
    }
}

