/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.node;

import io.avaje.json.node.JsonBoolean;
import io.avaje.json.node.JsonInteger;
import io.avaje.json.node.JsonLong;
import io.avaje.json.node.JsonNode;
import io.avaje.json.node.JsonString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public final class JsonArray
implements JsonNode {
    private static final long serialVersionUID = 1L;
    private static final JsonArray EMPTY = new JsonArray(Collections.emptyList());
    private final List<JsonNode> children;

    public static JsonArray empty() {
        return EMPTY;
    }

    public static JsonArray create() {
        return new JsonArray(new ArrayList<JsonNode>());
    }

    public static JsonArray of(List<JsonNode> children) {
        return new JsonArray(Collections.unmodifiableList(children));
    }

    private JsonArray(List<JsonNode> children) {
        this.children = Objects.requireNonNull(children);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JsonArray)) {
            return false;
        }
        JsonArray jsonArray = (JsonArray)object;
        return Objects.equals(this.children, jsonArray.children);
    }

    public int hashCode() {
        return Objects.hashCode(this.children);
    }

    public String toString() {
        return this.text();
    }

    @Override
    public JsonArray unmodifiable() {
        ArrayList<JsonNode> newList = new ArrayList<JsonNode>(this.children.size());
        for (JsonNode child : this.children) {
            newList.add(child.unmodifiable());
        }
        return JsonArray.of(newList);
    }

    @Override
    public JsonArray copy() {
        ArrayList<JsonNode> newList = new ArrayList<JsonNode>(this.children.size());
        for (JsonNode child : this.children) {
            newList.add(child.copy());
        }
        return new JsonArray(newList);
    }

    @Override
    public List<Object> toPlain() {
        ArrayList<Object> newList = new ArrayList<Object>(this.children.size());
        for (JsonNode child : this.children) {
            newList.add(child.toPlain());
        }
        return newList;
    }

    @Override
    public JsonNode.Type type() {
        return JsonNode.Type.ARRAY;
    }

    @Override
    public String text() {
        return this.children.toString();
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public int size() {
        return this.children.size();
    }

    public List<JsonNode> elements() {
        return this.children;
    }

    public Stream<JsonNode> stream() {
        return this.children.stream();
    }

    public JsonArray add(JsonNode element) {
        this.children.add(element);
        return this;
    }

    public JsonArray add(String value) {
        return this.add(JsonString.of(value));
    }

    public JsonArray add(boolean value) {
        return this.add(JsonBoolean.of(value));
    }

    public JsonArray add(int value) {
        return this.add(JsonInteger.of(value));
    }

    public JsonArray add(long value) {
        return this.add(JsonLong.of(value));
    }
}

