/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.node;

import io.avaje.json.JsonWriter;
import io.avaje.json.node.JsonNode;
import io.avaje.json.node.JsonNumber;
import java.math.BigDecimal;
import java.util.Objects;

public final class JsonDecimal
implements JsonNumber {
    private static final long serialVersionUID = 1L;
    private final BigDecimal value;

    public static JsonDecimal of(BigDecimal value) {
        return new JsonDecimal(value);
    }

    private JsonDecimal(BigDecimal value) {
        this.value = value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JsonDecimal)) {
            return false;
        }
        JsonDecimal that = (JsonDecimal)object;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return this.text();
    }

    @Override
    public JsonDecimal unmodifiable() {
        return this;
    }

    @Override
    public JsonDecimal copy() {
        return this;
    }

    @Override
    public BigDecimal toPlain() {
        return this.value;
    }

    @Override
    public JsonNode.Type type() {
        return JsonNode.Type.NUMBER;
    }

    @Override
    public String text() {
        return this.value.toString();
    }

    @Override
    public int intValue() {
        return this.value.intValueExact();
    }

    @Override
    public long longValue() {
        return this.value.longValueExact();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public BigDecimal decimalValue() {
        return this.value;
    }

    @Override
    public Number numberValue() {
        return this.value;
    }

    @Override
    public void toJson(JsonWriter writer) {
        writer.value(this.value);
    }
}

