/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.node;

import io.avaje.json.JsonWriter;
import io.avaje.json.node.JsonNode;
import io.avaje.json.node.JsonNumber;
import java.math.BigDecimal;
import java.util.Objects;

public final class JsonDouble
implements JsonNumber {
    private static final long serialVersionUID = 1L;
    private final double value;

    public static JsonDouble of(double value) {
        return new JsonDouble(value);
    }

    private JsonDouble(double value) {
        this.value = value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JsonDouble)) {
            return false;
        }
        JsonDouble that = (JsonDouble)object;
        return Double.compare(this.value, that.value) == 0;
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return this.text();
    }

    @Override
    public JsonDouble unmodifiable() {
        return this;
    }

    @Override
    public JsonDouble copy() {
        return this;
    }

    @Override
    public Double toPlain() {
        return this.value;
    }

    @Override
    public JsonNode.Type type() {
        return JsonNode.Type.NUMBER;
    }

    @Override
    public String text() {
        return Double.toString(this.value);
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public BigDecimal decimalValue() {
        return BigDecimal.valueOf(this.value);
    }

    @Override
    public Number numberValue() {
        return this.value;
    }

    @Override
    public void toJson(JsonWriter writer) {
        writer.value(this.value);
    }
}

