/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.node;

import io.avaje.json.JsonWriter;
import io.avaje.json.node.JsonNode;
import io.avaje.json.node.JsonNumber;
import java.math.BigDecimal;
import java.util.Objects;

public final class JsonLong
implements JsonNumber {
    private static final long serialVersionUID = 1L;
    private final long value;

    public static JsonLong of(long value) {
        return new JsonLong(value);
    }

    private JsonLong(long value) {
        this.value = value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JsonLong)) {
            return false;
        }
        JsonLong jsonLong = (JsonLong)object;
        return this.value == jsonLong.value;
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return this.text();
    }

    @Override
    public JsonLong unmodifiable() {
        return this;
    }

    @Override
    public JsonLong copy() {
        return this;
    }

    @Override
    public Long toPlain() {
        return this.value;
    }

    @Override
    public JsonNode.Type type() {
        return JsonNode.Type.NUMBER;
    }

    @Override
    public String text() {
        return Long.toString(this.value);
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public BigDecimal decimalValue() {
        return BigDecimal.valueOf(this.value);
    }

    @Override
    public Number numberValue() {
        return this.value;
    }

    @Override
    public void toJson(JsonWriter writer) {
        writer.value(this.value);
    }
}

