/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.node;

import io.avaje.json.node.JsonBoolean;
import io.avaje.json.node.JsonInteger;
import io.avaje.json.node.JsonLong;
import io.avaje.json.node.JsonNode;
import io.avaje.json.node.JsonNumber;
import io.avaje.json.node.JsonString;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

public final class JsonObject
implements JsonNode {
    private static final long serialVersionUID = 1L;
    private static final JsonObject EMPTY = new JsonObject(Collections.emptyMap());
    private static final Pattern PATH_PATTERN = Pattern.compile("\\.");
    private final Map<String, JsonNode> children;

    public static JsonObject empty() {
        return EMPTY;
    }

    public static JsonObject create() {
        return new JsonObject(new LinkedHashMap<String, JsonNode>());
    }

    public static JsonObject of(Map<String, JsonNode> elements) {
        return new JsonObject(Collections.unmodifiableMap(elements));
    }

    private JsonObject(Map<String, JsonNode> children) {
        this.children = Objects.requireNonNull(children);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JsonObject)) {
            return false;
        }
        JsonObject that = (JsonObject)object;
        return Objects.equals(this.children, that.children);
    }

    public int hashCode() {
        return Objects.hashCode(this.children);
    }

    public String toString() {
        return this.text();
    }

    @Override
    public JsonNode.Type type() {
        return JsonNode.Type.OBJECT;
    }

    @Override
    public String text() {
        return this.children.toString();
    }

    @Override
    public JsonObject unmodifiable() {
        LinkedHashMap<String, JsonNode> mapCopy = new LinkedHashMap<String, JsonNode>();
        for (Map.Entry<String, JsonNode> entry : this.children.entrySet()) {
            mapCopy.put(entry.getKey(), entry.getValue().unmodifiable());
        }
        return JsonObject.of(mapCopy);
    }

    @Override
    public JsonObject copy() {
        LinkedHashMap<String, JsonNode> mapCopy = new LinkedHashMap<String, JsonNode>();
        for (Map.Entry<String, JsonNode> entry : this.children.entrySet()) {
            mapCopy.put(entry.getKey(), entry.getValue().copy());
        }
        return new JsonObject(mapCopy);
    }

    @Override
    public Map<String, Object> toPlain() {
        LinkedHashMap<String, Object> mapCopy = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, JsonNode> entry : this.children.entrySet()) {
            mapCopy.put(entry.getKey(), entry.getValue().toPlain());
        }
        return mapCopy;
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public int size() {
        return this.children.size();
    }

    public boolean containsKey(String key) {
        return this.children.containsKey(key);
    }

    public Map<String, JsonNode> elements() {
        return this.children;
    }

    public JsonObject add(String key, JsonNode value) {
        this.children.put(key, value);
        return this;
    }

    public JsonObject add(String key, String value) {
        return this.add(key, JsonString.of(value));
    }

    public JsonObject add(String key, boolean value) {
        return this.add(key, JsonBoolean.of(value));
    }

    public JsonObject add(String key, int value) {
        return this.add(key, JsonInteger.of(value));
    }

    public JsonObject add(String key, long value) {
        return this.add(key, JsonLong.of(value));
    }

    public @Nullable JsonNode remove(String key) {
        return this.children.remove(key);
    }

    public JsonNode get(String key) {
        JsonNode node = this.children.get(key);
        if (node == null) {
            throw new IllegalArgumentException("Node not present for " + key);
        }
        return node;
    }

    @Override
    public @Nullable JsonNode find(String path) {
        String[] paths = PATH_PATTERN.split(path, 2);
        JsonNode child = this.children.get(paths[0]);
        if (child == null || paths.length == 1) {
            return child;
        }
        if (child instanceof JsonObject) {
            JsonObject co = (JsonObject)child;
            return co.find(paths[1]);
        }
        return null;
    }

    @Override
    public String extract(String path) {
        JsonNode node = this.find(path);
        if (node == null) {
            throw new IllegalArgumentException("Node not present for " + path);
        }
        return node.text();
    }

    @Override
    public Optional<String> extractOrEmpty(String path) {
        JsonNode name = this.find(path);
        return name == null ? Optional.empty() : Optional.of(name.text());
    }

    @Override
    public String extract(String path, String missingValue) {
        JsonNode name = this.find(path);
        return name == null ? missingValue : name.text();
    }

    @Override
    public int extract(String path, int missingValue) {
        JsonNode node = this.find(path);
        return !(node instanceof JsonNumber) ? missingValue : ((JsonNumber)node).intValue();
    }

    @Override
    public long extract(String path, long missingValue) {
        JsonNode node = this.find(path);
        return !(node instanceof JsonNumber) ? missingValue : ((JsonNumber)node).longValue();
    }

    @Override
    public Number extract(String path, Number missingValue) {
        JsonNode node = this.find(path);
        return !(node instanceof JsonNumber) ? (Number)missingValue : (Number)((JsonNumber)node).numberValue();
    }

    @Override
    public boolean extract(String path, boolean missingValue) {
        JsonNode node = this.find(path);
        return !(node instanceof JsonBoolean) ? missingValue : ((JsonBoolean)node).value();
    }

    @Override
    public JsonNode extractNode(String path) {
        JsonNode node = this.find(path);
        if (node == null) {
            throw new IllegalArgumentException("Node not present for " + path);
        }
        return node;
    }

    @Override
    public JsonNode extractNode(String path, JsonNode missingValue) {
        JsonNode node = this.find(path);
        return node != null ? node : missingValue;
    }

    @Override
    public Optional<JsonNode> extractNodeOrEmpty(String path) {
        JsonNode node = this.find(path);
        return Optional.ofNullable(node);
    }
}

