/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.node.adapter;

import io.avaje.json.JsonAdapter;
import io.avaje.json.JsonReader;
import io.avaje.json.JsonWriter;
import io.avaje.json.node.JsonArray;
import io.avaje.json.node.JsonNode;
import java.util.ArrayList;

final class ArrayAdapter
implements JsonAdapter<JsonArray> {
    private final JsonAdapter<JsonNode> elementAdapter;

    ArrayAdapter(JsonAdapter<JsonNode> elementAdapter) {
        this.elementAdapter = elementAdapter;
    }

    public JsonArray fromJson(JsonReader reader) {
        ArrayList<JsonNode> result = new ArrayList<JsonNode>();
        reader.beginArray();
        while (reader.hasNextElement()) {
            result.add((JsonNode)this.elementAdapter.fromJson(reader));
        }
        reader.endArray();
        return JsonArray.of(result);
    }

    public void toJson(JsonWriter writer, JsonArray value) {
        if (value.isEmpty()) {
            writer.emptyArray();
            return;
        }
        writer.beginArray();
        for (JsonNode element : value.elements()) {
            this.elementAdapter.toJson(writer, (Object)element);
        }
        writer.endArray();
    }
}

