/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.node.adapter;

import io.avaje.json.JsonAdapter;
import io.avaje.json.JsonReader;
import io.avaje.json.JsonWriter;
import io.avaje.json.PropertyNames;
import io.avaje.json.node.JsonArray;
import io.avaje.json.node.JsonBoolean;
import io.avaje.json.node.JsonDecimal;
import io.avaje.json.node.JsonDouble;
import io.avaje.json.node.JsonInteger;
import io.avaje.json.node.JsonLong;
import io.avaje.json.node.JsonNode;
import io.avaje.json.node.JsonNodeMapper;
import io.avaje.json.node.JsonNumber;
import io.avaje.json.node.JsonObject;
import io.avaje.json.node.JsonString;
import io.avaje.json.node.adapter.ArrayAdapter;
import io.avaje.json.node.adapter.BooleanAdapter;
import io.avaje.json.node.adapter.DMapper;
import io.avaje.json.node.adapter.DecimalAdapter;
import io.avaje.json.node.adapter.DoubleAdapter;
import io.avaje.json.node.adapter.IntegerAdapter;
import io.avaje.json.node.adapter.LongAdapter;
import io.avaje.json.node.adapter.NodeAdapter;
import io.avaje.json.node.adapter.NumberAdapter;
import io.avaje.json.node.adapter.ObjectAdapter;
import io.avaje.json.node.adapter.StringAdapter;
import io.avaje.json.simple.SimpleMapper;
import io.avaje.json.stream.BufferedJsonWriter;
import io.avaje.json.stream.JsonStream;
import java.lang.reflect.Type;

final class DJsonNodeMapper
implements JsonNodeMapper {
    static final BooleanAdapter BOOLEAN_ADAPTER = new BooleanAdapter();
    static final StringAdapter STRING_ADAPTER = new StringAdapter();
    static final IntegerAdapter INTEGER_ADAPTER = new IntegerAdapter();
    static final LongAdapter LONG_ADAPTER = new LongAdapter();
    static final DoubleAdapter DOUBLE_ADAPTER = new DoubleAdapter();
    static final DecimalAdapter DECIMAL_ADAPTER = new DecimalAdapter();
    static final NumberAdapter NUMBER_ADAPTER = new NumberAdapter();
    private final JsonStream jsonStream;
    private final NodeAdapter nodeAdapter;
    private final ObjectAdapter objectAdapter;
    private final ArrayAdapter arrayAdapter;

    DJsonNodeMapper(JsonStream jsonStream, NodeAdapter nodeAdapter, ObjectAdapter objectAdapter, ArrayAdapter arrayAdapter) {
        this.jsonStream = jsonStream;
        this.nodeAdapter = nodeAdapter;
        this.objectAdapter = objectAdapter;
        this.arrayAdapter = arrayAdapter;
    }

    @Override
    public PropertyNames properties(String ... names) {
        return this.jsonStream.properties(names);
    }

    @Override
    public <T> SimpleMapper.Type<T> type(JsonAdapter<T> customAdapter) {
        return new DMapper<T>(customAdapter, this.jsonStream);
    }

    @Override
    public SimpleMapper.Type<JsonNode> nodeMapper() {
        return new DMapper<JsonNode>(this.nodeAdapter, this.jsonStream);
    }

    @Override
    public SimpleMapper.Type<JsonObject> objectMapper() {
        return new DMapper<JsonObject>(this.objectAdapter, this.jsonStream);
    }

    @Override
    public SimpleMapper.Type<JsonArray> arrayMapper() {
        return new DMapper<JsonArray>(this.arrayAdapter, this.jsonStream);
    }

    @Override
    public String toJson(JsonNode node) {
        BufferedJsonWriter writer = this.jsonStream.bufferedWriter();
        this.nodeAdapter.toJson((JsonWriter)writer, node);
        return writer.result();
    }

    @Override
    public JsonNode fromJson(String json) {
        try (JsonReader reader = this.jsonStream.reader(json);){
            JsonNode jsonNode = this.nodeAdapter.fromJson(reader);
            return jsonNode;
        }
    }

    @Override
    public JsonObject fromJsonObject(String json) {
        try (JsonReader reader = this.jsonStream.reader(json);){
            JsonObject jsonObject = this.objectAdapter.fromJson(reader);
            return jsonObject;
        }
    }

    @Override
    public JsonArray fromJsonArray(String json) {
        try (JsonReader reader = this.jsonStream.reader(json);){
            JsonArray jsonArray = this.arrayAdapter.fromJson(reader);
            return jsonArray;
        }
    }

    @Override
    public <T extends JsonNode> T fromJson(Class<T> type, String json) {
        JsonAdapter<T> adapter = this.adapter(type);
        try (JsonReader reader = this.jsonStream.reader(json);){
            JsonNode jsonNode = (JsonNode)adapter.fromJson(reader);
            return (T)jsonNode;
        }
    }

    @Override
    public JsonAdapter<?> adapter(Type type) {
        Class cls;
        if (type instanceof Class && JsonNode.class.isAssignableFrom(cls = (Class)type)) {
            return this.adapter(cls);
        }
        return null;
    }

    @Override
    public <T extends JsonNode> JsonAdapter<T> adapter(Class<T> type) {
        if (type == JsonNode.class) {
            return this.nodeAdapter;
        }
        if (type == JsonObject.class) {
            return this.objectAdapter;
        }
        if (type == JsonArray.class) {
            return this.arrayAdapter;
        }
        if (type == JsonBoolean.class) {
            return BOOLEAN_ADAPTER;
        }
        if (type == JsonString.class) {
            return STRING_ADAPTER;
        }
        if (type == JsonInteger.class) {
            return INTEGER_ADAPTER;
        }
        if (type == JsonLong.class) {
            return LONG_ADAPTER;
        }
        if (type == JsonDouble.class) {
            return DOUBLE_ADAPTER;
        }
        if (type == JsonDecimal.class) {
            return DECIMAL_ADAPTER;
        }
        if (type == JsonNumber.class) {
            return NUMBER_ADAPTER;
        }
        throw new IllegalArgumentException("Unexpected type " + String.valueOf(type) + " is not a JsonNode?");
    }
}

