/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.node.adapter;

import io.avaje.json.JsonAdapter;
import io.avaje.json.JsonException;
import io.avaje.json.JsonReader;
import io.avaje.json.JsonWriter;
import io.avaje.json.core.CoreTypes;
import io.avaje.json.simple.SimpleMapper;
import io.avaje.json.stream.BufferedJsonWriter;
import io.avaje.json.stream.BytesJsonWriter;
import io.avaje.json.stream.JsonStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;

final class DMapper<T>
implements SimpleMapper.Type<T> {
    private final JsonAdapter<T> adapter;
    private final JsonStream jsonStream;

    DMapper(JsonAdapter<T> adapter, JsonStream jsonStream) {
        this.adapter = adapter;
        this.jsonStream = jsonStream;
    }

    public SimpleMapper.Type<List<T>> list() {
        JsonAdapter list = CoreTypes.createList(this.adapter);
        return new DMapper<List<T>>(list, this.jsonStream);
    }

    public SimpleMapper.Type<Map<String, T>> map() {
        JsonAdapter map = CoreTypes.createMap(this.adapter);
        return new DMapper<Map<String, T>>(map, this.jsonStream);
    }

    public T fromJson(JsonReader reader) {
        return (T)this.adapter.fromJson(reader);
    }

    public T fromJson(String content) {
        try (JsonReader reader = this.jsonStream.reader(content);){
            Object object = this.adapter.fromJson(reader);
            return (T)object;
        }
    }

    public T fromJson(byte[] content) {
        try (JsonReader reader = this.jsonStream.reader(content);){
            Object object = this.adapter.fromJson(reader);
            return (T)object;
        }
    }

    public T fromJson(Reader content) {
        try (JsonReader reader = this.jsonStream.reader(content);){
            Object object = this.adapter.fromJson(reader);
            return (T)object;
        }
    }

    public T fromJson(InputStream content) {
        try (JsonReader reader = this.jsonStream.reader(content);){
            Object object = this.adapter.fromJson(reader);
            return (T)object;
        }
    }

    public String toJson(T value) {
        try (BufferedJsonWriter writer = this.jsonStream.bufferedWriter();){
            this.toJson(value, (JsonWriter)writer);
            String string = writer.result();
            return string;
        }
    }

    public String toJsonPretty(T value) {
        try (BufferedJsonWriter writer = this.jsonStream.bufferedWriter();){
            writer.pretty(true);
            this.toJson(value, (JsonWriter)writer);
            String string = writer.result();
            return string;
        }
    }

    public byte[] toJsonBytes(T value) {
        try (BytesJsonWriter writer = this.jsonStream.bufferedWriterAsBytes();){
            this.toJson(value, (JsonWriter)writer);
            byte[] byArray = writer.result();
            return byArray;
        }
    }

    public void toJson(T value, JsonWriter writer) {
        try {
            this.adapter.toJson(writer, value);
        }
        catch (RuntimeException e) {
            writer.markIncomplete();
            throw new JsonException((Throwable)e);
        }
    }

    public void toJson(T value, Writer writer) {
        try (JsonWriter jsonWriter = this.jsonStream.writer(writer);){
            this.toJson(value, jsonWriter);
        }
    }

    public void toJson(T value, OutputStream outputStream) {
        try (JsonWriter writer = this.jsonStream.writer(outputStream);){
            this.toJson(value, writer);
        }
        this.close(outputStream);
    }

    private void close(Closeable outputStream) {
        try {
            outputStream.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error closing stream", e);
        }
    }
}

