/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.node.adapter;

import io.avaje.json.JsonAdapter;
import io.avaje.json.JsonReader;
import io.avaje.json.JsonWriter;
import io.avaje.json.node.JsonArray;
import io.avaje.json.node.JsonBoolean;
import io.avaje.json.node.JsonNode;
import io.avaje.json.node.JsonNumber;
import io.avaje.json.node.JsonObject;
import io.avaje.json.node.JsonString;
import io.avaje.json.node.adapter.ArrayAdapter;
import io.avaje.json.node.adapter.BooleanAdapter;
import io.avaje.json.node.adapter.DJsonNodeMapper;
import io.avaje.json.node.adapter.ObjectAdapter;
import io.avaje.json.node.adapter.StringAdapter;

final class NodeAdapter
implements JsonAdapter<JsonNode> {
    private final BooleanAdapter booleanAdapter = DJsonNodeMapper.BOOLEAN_ADAPTER;
    private final StringAdapter stringAdapter = DJsonNodeMapper.STRING_ADAPTER;
    private final ArrayAdapter arrayAdapter;
    private final ObjectAdapter objectAdapter;
    private final JsonAdapter<JsonNumber> numberAdapter;

    NodeAdapter(JsonAdapter<JsonNumber> numberAdapter) {
        this.numberAdapter = numberAdapter;
        this.arrayAdapter = new ArrayAdapter(this);
        this.objectAdapter = new ObjectAdapter(this);
    }

    ArrayAdapter arrayAdapter() {
        return this.arrayAdapter;
    }

    ObjectAdapter objectAdapter() {
        return this.objectAdapter;
    }

    public JsonNode fromJson(JsonReader reader) {
        switch (reader.currentToken()) {
            case NULL: {
                reader.isNullValue();
                return null;
            }
            case BEGIN_ARRAY: {
                return this.arrayAdapter.fromJson(reader);
            }
            case BEGIN_OBJECT: {
                return this.objectAdapter.fromJson(reader);
            }
            case STRING: {
                return this.stringAdapter.fromJson(reader);
            }
            case BOOLEAN: {
                return this.booleanAdapter.fromJson(reader);
            }
            case NUMBER: {
                return (JsonNode)this.numberAdapter.fromJson(reader);
            }
        }
        throw new IllegalStateException("Expected a value but was " + String.valueOf(reader.currentToken()) + " at path " + reader.location());
    }

    public void toJson(JsonWriter writer, JsonNode value) {
        if (value == null) {
            writer.nullValue();
            return;
        }
        switch (value.type()) {
            case NULL: {
                writer.nullValue();
                break;
            }
            case ARRAY: {
                this.arrayAdapter.toJson(writer, (JsonArray)value);
                break;
            }
            case OBJECT: {
                this.objectAdapter.toJson(writer, (JsonObject)value);
                break;
            }
            case BOOLEAN: {
                this.booleanAdapter.toJson(writer, (JsonBoolean)value);
                break;
            }
            case STRING: {
                this.stringAdapter.toJson(writer, (JsonString)value);
                break;
            }
            case NUMBER: {
                this.numberAdapter.toJson(writer, (Object)((JsonNumber)value));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Type not supported " + String.valueOf(value.getClass()));
            }
        }
    }

    public String toString() {
        return "JsonNodeAdapter";
    }
}

