/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.node.adapter;

import io.avaje.json.JsonAdapter;
import io.avaje.json.node.JsonNodeMapper;
import io.avaje.json.node.JsonNumber;
import io.avaje.json.node.adapter.ArrayAdapter;
import io.avaje.json.node.adapter.DJsonNodeMapper;
import io.avaje.json.node.adapter.NodeAdapter;
import io.avaje.json.node.adapter.ObjectAdapter;
import io.avaje.json.stream.JsonStream;

public final class NodeAdapterBuilder
implements JsonNodeMapper.Builder {
    private JsonStream jsonStream;
    private JsonAdapter<JsonNumber> numberAdapter;

    @Override
    public JsonNodeMapper.Builder jsonStream(JsonStream jsonStream) {
        this.jsonStream = jsonStream;
        return this;
    }

    @Override
    public JsonNodeMapper.Builder numberAdapter(JsonAdapter<JsonNumber> numberAdapter) {
        this.numberAdapter = numberAdapter;
        return this;
    }

    @Override
    public JsonNodeMapper build() {
        JsonStream stream = this.jsonStream != null ? this.jsonStream : JsonStream.builder().build();
        JsonAdapter<JsonNumber> number = this.numberAdapter != null ? this.numberAdapter : DJsonNodeMapper.NUMBER_ADAPTER;
        NodeAdapter nodeAdapter = new NodeAdapter(number);
        ObjectAdapter objectAdapter = nodeAdapter.objectAdapter();
        ArrayAdapter arrayAdapter = nodeAdapter.arrayAdapter();
        return new DJsonNodeMapper(stream, nodeAdapter, objectAdapter, arrayAdapter);
    }
}

