/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.node.adapter;

import io.avaje.json.JsonAdapter;
import io.avaje.json.JsonDataException;
import io.avaje.json.JsonReader;
import io.avaje.json.JsonWriter;
import io.avaje.json.node.JsonNode;
import io.avaje.json.node.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;

final class ObjectAdapter
implements JsonAdapter<JsonObject> {
    private final JsonAdapter<JsonNode> valueAdapter;

    ObjectAdapter(JsonAdapter<JsonNode> valueAdapter) {
        this.valueAdapter = valueAdapter;
    }

    public void toJson(JsonWriter writer, JsonObject value) {
        writer.beginObject();
        for (Map.Entry<String, JsonNode> entry : value.elements().entrySet()) {
            if (entry.getKey() == null) {
                throw new JsonDataException("Map key is null at " + writer.path());
            }
            writer.name(entry.getKey());
            this.valueAdapter.toJson(writer, (Object)entry.getValue());
        }
        writer.endObject();
    }

    public JsonObject fromJson(JsonReader reader) {
        LinkedHashMap<String, JsonNode> result = new LinkedHashMap<String, JsonNode>();
        reader.beginObject();
        while (reader.hasNextField()) {
            JsonNode value;
            String name = reader.nextField();
            JsonNode replaced = result.put(name, value = (JsonNode)this.valueAdapter.fromJson(reader));
            if (replaced == null) continue;
            throw new JsonDataException(String.format("Map key '%s' has multiple values at path %s : %s and %s", name, reader.location(), replaced, value));
        }
        reader.endObject();
        return JsonObject.of(result);
    }

    public String toString() {
        return "JsonObject()";
    }
}

