/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.core;

import io.avaje.json.JsonAdapter;
import io.avaje.json.JsonReader;
import io.avaje.json.JsonWriter;
import io.avaje.json.core.CoreTypes;
import java.util.List;
import java.util.Map;

final class BasicObjectAdapter
implements JsonAdapter<Object> {
    private final JsonAdapter<String> stringAdapter = CoreTypes.create(String.class);
    private final JsonAdapter<Double> doubleAdapter;
    private final JsonAdapter<Integer> intAdapter = CoreTypes.create(Integer.class);
    private final JsonAdapter<Long> longAdapter;
    private final JsonAdapter<Boolean> booleanAdapter;
    private final JsonAdapter<List<Object>> listAdapter;
    private final JsonAdapter<Map<String, Object>> mapAdapter;

    BasicObjectAdapter() {
        this.doubleAdapter = CoreTypes.create(Double.class);
        this.longAdapter = CoreTypes.create(Long.class);
        this.booleanAdapter = CoreTypes.create(Boolean.class);
        this.listAdapter = CoreTypes.createList(this);
        this.mapAdapter = CoreTypes.createMap(this);
    }

    @Override
    public Object fromJson(JsonReader reader) {
        switch (reader.currentToken()) {
            case BEGIN_ARRAY: {
                return this.listAdapter.fromJson(reader);
            }
            case BEGIN_OBJECT: {
                return this.mapAdapter.fromJson(reader);
            }
            case STRING: {
                return this.stringAdapter.fromJson(reader);
            }
            case NUMBER: {
                Double d = this.doubleAdapter.fromJson(reader);
                if (d % 1.0 == 0.0) {
                    return d.longValue();
                }
                return d;
            }
            case BOOLEAN: {
                return this.booleanAdapter.fromJson(reader);
            }
            case NULL: {
                return null;
            }
        }
        throw new IllegalStateException("Expected a value but was " + String.valueOf((Object)reader.currentToken()) + " at path " + reader.location());
    }

    @Override
    public void toJson(JsonWriter writer, Object value) {
        if (value == null) {
            writer.nullValue();
            return;
        }
        Class<?> valueClass = value.getClass();
        if (valueClass == String.class) {
            this.stringAdapter.toJson(writer, (String)value);
        } else if (value instanceof List) {
            this.listAdapter.toJson(writer, (List)value);
        } else if (value instanceof Boolean) {
            this.booleanAdapter.toJson(writer, (Boolean)value);
        } else if (value instanceof Integer) {
            this.intAdapter.toJson(writer, (Integer)value);
        } else if (value instanceof Long) {
            this.longAdapter.toJson(writer, (Long)value);
        } else if (value instanceof Double) {
            this.doubleAdapter.toJson(writer, (Double)value);
        } else if (Map.class.isAssignableFrom(valueClass)) {
            this.mapAdapter.toJson(writer, (Map)value);
        } else {
            throw new UnsupportedOperationException("Type not supported " + String.valueOf(value.getClass()));
        }
    }

    public String toString() {
        return "BasicObjectAdapter";
    }
}

