/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.stream.core;

import io.avaje.json.stream.BufferRecycleStrategy;
import io.avaje.json.stream.JsonStream;
import io.avaje.json.stream.core.CoreJsonStream;

public final class JsonStreamBuilder
implements JsonStream.Builder {
    private BufferRecycleStrategy strategy = BufferRecycleStrategy.HYBRID_POOL;
    private boolean serializeNulls;
    private boolean serializeEmpty;
    private boolean failOnUnknown;

    @Override
    public JsonStreamBuilder serializeNulls(boolean serializeNulls) {
        this.serializeNulls = serializeNulls;
        return this;
    }

    @Override
    public JsonStreamBuilder serializeEmpty(boolean serializeEmpty) {
        this.serializeEmpty = serializeEmpty;
        return this;
    }

    @Override
    public JsonStreamBuilder failOnUnknown(boolean failOnUnknown) {
        this.failOnUnknown = failOnUnknown;
        return this;
    }

    @Override
    public JsonStreamBuilder bufferRecycling(BufferRecycleStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    @Override
    public JsonStream build() {
        return new CoreJsonStream(this.serializeNulls, this.serializeEmpty, this.failOnUnknown, this.strategy);
    }
}

