/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.stream.core;

import io.avaje.json.stream.core.JParser;
import java.math.BigDecimal;
import java.math.BigInteger;

final class NumberParser {
    private static final int[] DIFF = new int[]{111, 222, 444, 888, 1776};
    private static final int[] ERROR = new int[]{50, 100, 200, 400, 800};
    private static final int[] SCALE_10 = new int[]{10000, 1000, 100, 10, 1};
    private static final double[] POW_10 = new double[]{10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22, 1.0E23, 1.0E24, 1.0E25, 1.0E26, 1.0E27, 1.0E28, 1.0E29, 1.0E30, 1.0E31, 1.0E32, 1.0E33, 1.0E34, 1.0E35, 1.0E36, 1.0E37, 1.0E38, 1.0E39, 1.0E40, 1.0E41, 1.0E42, 1.0E43, 1.0E44, 1.0E45, 1.0E46, 1.0E47, 1.0E48, 1.0E49, 1.0E50, 1.0E51, 1.0E52, 1.0E53, 1.0E54, 1.0E55, 1.0E56, 1.0E57, 1.0E58, 1.0E59, 1.0E60, 1.0E61, 1.0E62, 1.0E63, 1.0E64, 1.0E65};

    NumberParser() {
    }

    static short deserializeShort(JParser reader) {
        int value;
        if (reader.currentToken() == 34) {
            int position = reader.getCurrentIndex();
            char[] buf = reader.readSimpleQuote();
            try {
                return NumberParser.parseNumberGeneric(buf, reader.getCurrentIndex() - position - 1, reader, true).shortValueExact();
            }
            catch (ArithmeticException ignore) {
                throw reader.newParseErrorAt("Short overflow detected", reader.getCurrentIndex() - position);
            }
        }
        int start = reader.scanNumber();
        int end = reader.getCurrentIndex();
        byte[] buf = reader.buffer;
        byte ch = buf[start];
        int n = value = ch == 45 ? NumberParser.parseNegativeInt(buf, reader, start, end) : NumberParser.parsePositiveInt(buf, reader, start, end, 0);
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw reader.newParseErrorAt("Short overflow detected", reader.getCurrentIndex());
        }
        return (short)value;
    }

    static int deserializeInt(JParser reader) {
        if (reader.currentToken() == 34) {
            int position = reader.getCurrentIndex();
            char[] buf = reader.readSimpleQuote();
            try {
                return NumberParser.parseNumberGeneric(buf, reader.getCurrentIndex() - position - 1, reader, true).intValueExact();
            }
            catch (ArithmeticException ignore) {
                throw reader.newParseErrorAt("Integer overflow detected", reader.getCurrentIndex() - position);
            }
        }
        int start = reader.scanNumber();
        int end = reader.getCurrentIndex();
        byte[] buf = reader.buffer;
        byte ch = buf[start];
        if (ch == 45) {
            if (end > start + 2 && buf[start + 1] == 48 && buf[start + 2] >= 48 && buf[start + 2] <= 57) {
                NumberParser.numberException(reader, start, end, "Leading zero is not allowed");
            }
            return NumberParser.parseNegativeInt(buf, reader, start, end);
        }
        if (ch == 48 && end > start + 1 && buf[start + 1] >= 48 && buf[start + 1] <= 57) {
            NumberParser.numberException(reader, start, end, "Leading zero is not allowed");
        }
        return NumberParser.parsePositiveInt(buf, reader, start, end, 0);
    }

    private static int parsePositiveInt(byte[] buf, JParser reader, int start, int end, int offset) {
        int value = 0;
        int i = start + offset;
        if (i == end) {
            NumberParser.numberException(reader, start, end, "Digit not found");
        }
        while (i < end) {
            int ind = buf[i] - 48;
            if (ind < 0 || ind > 9) {
                BigDecimal v;
                if (i > start + offset && reader.allWhitespace(i, end)) {
                    return value;
                }
                if (i == end - 1 && buf[i] == 46) {
                    NumberParser.numberException(reader, start, end, "Number ends with a dot");
                }
                if ((v = NumberParser.parseNumberGeneric(reader.prepareBuffer(start, end - start), end - start, reader, false)).scale() > 0) {
                    NumberParser.numberException(reader, start, end, "Expecting int but found decimal value", v);
                }
                return v.intValue();
            }
            if ((value = (value << 3) + (value << 1) + ind) < 0) {
                NumberParser.numberException(reader, start, end, "Integer overflow detected");
            }
            ++i;
        }
        return value;
    }

    private static int parseNegativeInt(byte[] buf, JParser reader, int start, int end) {
        int value = 0;
        int i = start + 1;
        if (i == end) {
            NumberParser.numberException(reader, start, end, "Digit not found");
        }
        while (i < end) {
            int ind = buf[i] - 48;
            if (ind < 0 || ind > 9) {
                BigDecimal v;
                if (i > start + 1 && reader.allWhitespace(i, end)) {
                    return value;
                }
                if (i == end - 1 && buf[i] == 46) {
                    NumberParser.numberException(reader, start, end, "Number ends with a dot");
                }
                if ((v = NumberParser.parseNumberGeneric(reader.prepareBuffer(start, end - start), end - start, reader, false)).scale() > 0) {
                    NumberParser.numberException(reader, start, end, "Expecting int but found decimal value", v);
                }
                return v.intValue();
            }
            if ((value = (value << 3) + (value << 1) - ind) > 0) {
                NumberParser.numberException(reader, start, end, "Integer overflow detected");
            }
            ++i;
        }
        return value;
    }

    private static BigDecimal parseNumberGeneric(char[] buf, int len, JParser reader, boolean withQuotes) {
        int offset;
        int end;
        for (end = len; end > 0 && Character.isWhitespace(buf[end - 1]); --end) {
        }
        if (end > reader.maxNumberDigits) {
            throw reader.newParseErrorWith("Too many digits detected in number", len, "Too many digits detected in number", end, "");
        }
        int n = offset = buf[0] == '-' ? 1 : 0;
        if (buf[offset] == '0' && end > offset + 1 && buf[offset + 1] >= '0' && buf[offset + 1] <= '9') {
            throw reader.newParseErrorAt("Leading zero is not allowed. Error parsing number", len + (withQuotes ? 2 : 0));
        }
        try {
            return new BigDecimal(buf, 0, end);
        }
        catch (NumberFormatException nfe) {
            throw reader.newParseErrorAt("Error parsing number", len + (withQuotes ? 2 : 0), nfe);
        }
    }

    static void numberException(JParser reader, int start, int end, String message) {
        int len = end - start;
        if (len > reader.maxNumberDigits) {
            throw reader.newParseErrorWith("Too many digits detected in number", len, "Too many digits detected in number", end, "");
        }
        throw reader.newParseErrorWith("Error parsing number", len, message, null, ". Error parsing number");
    }

    static void numberException(JParser reader, int start, int end, String message, Object messageArgument) {
        int len = end - start;
        if (len > reader.maxNumberDigits) {
            throw reader.newParseErrorWith("Too many digits detected in number", len, "Too many digits detected in number", end, "");
        }
        throw reader.newParseErrorWith("Error parsing number", len, message, messageArgument, ". Error parsing number");
    }

    static long deserializeLong(JParser reader) {
        boolean leadingZero;
        if (reader.currentToken() == 34) {
            int position = reader.getCurrentIndex();
            char[] buf = reader.readSimpleQuote();
            try {
                return NumberParser.parseNumberGeneric(buf, reader.getCurrentIndex() - position - 1, reader, true).longValueExact();
            }
            catch (ArithmeticException ignore) {
                throw reader.newParseErrorAt("Long overflow detected", reader.getCurrentIndex() - position);
            }
        }
        int start = reader.scanNumber();
        int end = reader.getCurrentIndex();
        byte[] buf = reader.buffer;
        byte ch = buf[start];
        int i = start;
        long value = 0L;
        if (ch == 45) {
            boolean leadingZero2;
            i = start + 1;
            if (i == end) {
                NumberParser.numberException(reader, start, end, "Digit not found");
            }
            boolean bl = leadingZero2 = buf[i] == 48;
            while (i < end) {
                int ind = buf[i] - 48;
                if (ind < 0 || ind > 9) {
                    if (leadingZero2 && i > start + 2) {
                        NumberParser.numberException(reader, start, end, "Leading zero is not allowed");
                    }
                    if (i > start + 1 && reader.allWhitespace(i, end)) {
                        return value;
                    }
                    return NumberParser.parseLongGeneric(reader, start, end);
                }
                if ((value = (value << 3) + (value << 1) - (long)ind) > 0L) {
                    NumberParser.numberException(reader, start, end, "Long overflow detected");
                }
                ++i;
            }
            if (leadingZero2 && i > start + 2) {
                NumberParser.numberException(reader, start, end, "Leading zero is not allowed");
            }
            return value;
        }
        if (i == end) {
            NumberParser.numberException(reader, start, end, "Digit not found");
        }
        boolean bl = leadingZero = buf[i] == 48;
        while (i < end) {
            int ind = buf[i] - 48;
            if (ind < 0 || ind > 9) {
                if (leadingZero && i > start + 1) {
                    NumberParser.numberException(reader, start, end, "Leading zero is not allowed");
                }
                if (ch == 43 && i > start + 1 && reader.allWhitespace(i, end)) {
                    return value;
                }
                if (ch != 43 && i > start && reader.allWhitespace(i, end)) {
                    return value;
                }
                return NumberParser.parseLongGeneric(reader, start, end);
            }
            if ((value = (value << 3) + (value << 1) + (long)ind) < 0L) {
                NumberParser.numberException(reader, start, end, "Long overflow detected");
            }
            ++i;
        }
        if (leadingZero && i > start + 1) {
            NumberParser.numberException(reader, start, end, "Leading zero is not allowed");
        }
        return value;
    }

    private static long parseLongGeneric(JParser reader, int start, int end) {
        BigDecimal v;
        int len = end - start;
        char[] buf = reader.prepareBuffer(start, len);
        if (len > 0 && buf[len - 1] == '.') {
            NumberParser.numberException(reader, start, end, "Number ends with a dot");
        }
        if ((v = NumberParser.parseNumberGeneric(buf, len, reader, false)).scale() > 0) {
            NumberParser.numberException(reader, start, end, "Expecting long, but found decimal value ", v);
        }
        return v.longValue();
    }

    private static NumberInfo readLongNumber(JParser reader, int start) {
        int len = reader.length() - start;
        char[] result = reader.prepareBuffer(start, len);
        while (reader.length() == reader.getCurrentIndex() && !reader.isEndOfStream()) {
            reader.scanNumber();
            int end = reader.getCurrentIndex();
            int oldLen = len;
            if ((len += end) > reader.maxNumberDigits) {
                throw reader.newParseErrorFormat("Too many digits detected in number", len, "Number of digits larger than %d. Unable to read number", reader.maxNumberDigits);
            }
            char[] tmp = result;
            result = new char[len];
            System.arraycopy(tmp, 0, result, 0, oldLen);
            System.arraycopy(reader.prepareBuffer(0, end), 0, result, oldLen, end);
        }
        return new NumberInfo(result, len);
    }

    static double deserializeDouble(JParser reader) {
        if (reader.currentToken() == 34) {
            int position = reader.getCurrentIndex();
            char[] buf = reader.readSimpleQuote();
            return NumberParser.parseDoubleGeneric(buf, reader.getCurrentIndex() - position - 1, reader, true);
        }
        int start = reader.scanNumber();
        int end = reader.getCurrentIndex();
        byte[] buf = reader.buffer;
        byte ch = buf[start];
        if (ch == 45) {
            return -NumberParser.parseDouble(buf, reader, start, end, 1);
        }
        return NumberParser.parseDouble(buf, reader, start, end, 0);
    }

    private static double parseDouble(byte[] buf, JParser reader, int start, int end, int offset) {
        int i;
        boolean leadingZero;
        if (end - start - offset > reader.doubleLengthLimit) {
            if (end == reader.length()) {
                NumberInfo tmp = NumberParser.readLongNumber(reader, start + offset);
                return NumberParser.parseDoubleGeneric(tmp.buffer, tmp.length, reader, false);
            }
            return NumberParser.parseDoubleGeneric(reader.prepareBuffer(start + offset, end - start - offset), end - start - offset, reader, false);
        }
        long value = 0L;
        int ch = 32;
        boolean bl = leadingZero = buf[start + offset] == 48;
        for (i = start + offset; i < end && (ch = buf[i]) != 46 && ch != 101 && ch != 69; ++i) {
            int ind = buf[i] - 48;
            if (ind < 0 || ind > 9) {
                if (leadingZero && i > start + offset + 1) {
                    NumberParser.numberException(reader, start, end, "Leading zero is not allowed");
                }
                if (i > start + offset && reader.allWhitespace(i, end)) {
                    return value;
                }
                NumberParser.numberException(reader, start, end, "Unknown digit", Character.valueOf((char)ch));
            }
            value = (value << 3) + (value << 1) + (long)ind;
        }
        if (i == start + offset) {
            NumberParser.numberException(reader, start, end, "Digit not found");
        } else if (leadingZero && ch != 46 && i > start + offset + 1) {
            NumberParser.numberException(reader, start, end, "Leading zero is not allowed");
        } else {
            if (i == end) {
                return value;
            }
            if (ch == 46) {
                int decOffset;
                int expDiff;
                double preciseDividor;
                int maxLen;
                if (++i == end) {
                    NumberParser.numberException(reader, start, end, "Number ends with a dot");
                }
                int decPos = i;
                if (value == 0L) {
                    maxLen = i + 15;
                    ch = buf[i];
                    if (ch == 48 && end > maxLen) {
                        return NumberParser.parseDoubleGeneric(reader.prepareBuffer(start + offset, end - start - offset), end - start - offset, reader, false);
                    }
                    if (ch < 56) {
                        preciseDividor = 1.0E14;
                        expDiff = -1;
                        decOffset = 1;
                    } else {
                        preciseDividor = 1.0E15;
                        expDiff = 0;
                        decOffset = 0;
                    }
                } else {
                    maxLen = start + offset + 16;
                    if (buf[start + offset] < 56) {
                        preciseDividor = 1.0E14;
                        expDiff = i - maxLen + 14;
                        decOffset = 1;
                    } else {
                        preciseDividor = 1.0E15;
                        expDiff = i - maxLen + 15;
                        decOffset = 0;
                    }
                }
                int numLimit = Math.min(maxLen, end);
                while (i < numLimit && (ch = buf[i]) != 101 && ch != 69) {
                    int ind = ch - 48;
                    if (ind < 0 || ind > 9) {
                        if (reader.allWhitespace(i, end)) {
                            return (double)value / POW_10[i - decPos - 1];
                        }
                        NumberParser.numberException(reader, start, end, "Unknown digit", Character.valueOf((char)buf[i]));
                    }
                    value = (value << 3) + (value << 1) + (long)ind;
                    ++i;
                }
                if (i == end) {
                    return (double)value / POW_10[i - decPos - 1];
                }
                if (ch == 101 || ch == 69) {
                    return NumberParser.doubleExponent(reader, value, i - decPos, 0.0, buf, start, end, offset, i);
                }
                if (reader.doublePrecision == JParser.DoublePrecision.HIGH) {
                    return NumberParser.parseDoubleGeneric(reader.prepareBuffer(start + offset, end - start - offset), end - start - offset, reader, false);
                }
                int decimals = 0;
                int decLimit = Math.min(start + offset + 18, end);
                int remPos = i;
                while (i < decLimit && (ch = buf[i]) != 101 && ch != 69) {
                    int ind = ch - 48;
                    if (ind < 0 || ind > 9) {
                        if (reader.allWhitespace(i, end)) {
                            return NumberParser.approximateDouble(decimals, (double)value / preciseDividor, i - remPos - decOffset);
                        }
                        NumberParser.numberException(reader, start, end, "Unknown digit", Character.valueOf((char)buf[i]));
                    }
                    decimals = (decimals << 3) + (decimals << 1) + ind;
                    ++i;
                }
                double number = NumberParser.approximateDouble(decimals, (double)value / preciseDividor, i - remPos - decOffset);
                while (i < end && ch >= 48 && ch <= 57) {
                    ch = buf[i++];
                }
                if (ch == 101 || ch == 69) {
                    return NumberParser.doubleExponent(reader, 0L, expDiff, number, buf, start, end, offset, i);
                }
                if (expDiff > 0) {
                    return number * POW_10[expDiff - 1];
                }
                if (expDiff < 0) {
                    return number / POW_10[-expDiff - 1];
                }
                return number;
            }
            if (ch == 101 || ch == 69) {
                return NumberParser.doubleExponent(reader, value, 0, 0.0, buf, start, end, offset, i);
            }
        }
        return value;
    }

    private static double approximateDouble(int decimals, double precise, int digits) {
        long bits = Double.doubleToRawLongBits(precise);
        int exp = (int)(bits >> 52) - 1022;
        int missing = (decimals * SCALE_10[digits + 1] + ERROR[exp]) / DIFF[exp];
        return Double.longBitsToDouble(bits + (long)missing);
    }

    private static double doubleExponent(JParser reader, long whole, int decimals, double fraction, byte[] buf, int start, int end, int offset, int i) {
        byte ch;
        if (reader.doublePrecision == JParser.DoublePrecision.EXACT) {
            return NumberParser.parseDoubleGeneric(reader.prepareBuffer(start + offset, end - start - offset), end - start - offset, reader, false);
        }
        int exp = (ch = buf[++i]) == 45 ? NumberParser.parseNegativeInt(buf, reader, i, end) - decimals : (ch == 43 ? NumberParser.parsePositiveInt(buf, reader, i, end, 1) - decimals : NumberParser.parsePositiveInt(buf, reader, i, end, 0) - decimals);
        if (fraction == 0.0) {
            if (exp == 0 || whole == 0L) {
                return whole;
            }
            if (exp > 0 && exp < POW_10.length) {
                return (double)whole * POW_10[exp - 1];
            }
            if (exp < 0 && -exp < POW_10.length) {
                return (double)whole / POW_10[-exp - 1];
            }
            if (reader.doublePrecision != JParser.DoublePrecision.HIGH) {
                if (exp > 0 && exp < 300) {
                    return (double)whole * Math.pow(10.0, exp);
                }
                if (exp > -300 && exp < 0) {
                    return (double)whole / Math.pow(10.0, exp);
                }
            }
        } else {
            if (exp == 0) {
                return (double)whole + fraction;
            }
            if (exp > 0 && exp < POW_10.length) {
                return fraction * POW_10[exp - 1] + (double)whole * POW_10[exp - 1];
            }
            if (exp < 0 && -exp < POW_10.length) {
                return fraction / POW_10[-exp - 1] + (double)whole / POW_10[-exp - 1];
            }
            if (reader.doublePrecision != JParser.DoublePrecision.HIGH) {
                if (exp > 0 && exp < 300) {
                    return (double)whole * Math.pow(10.0, exp);
                }
                if (exp > -300 && exp < 0) {
                    return (double)whole / Math.pow(10.0, exp);
                }
            }
        }
        return NumberParser.parseDoubleGeneric(reader.prepareBuffer(start + offset, end - start - offset), end - start - offset, reader, false);
    }

    private static double parseDoubleGeneric(char[] buf, int len, JParser reader, boolean withQuotes) {
        int offset;
        int end;
        for (end = len; end > 0 && Character.isWhitespace(buf[end - 1]); --end) {
        }
        if (end > reader.maxNumberDigits) {
            throw reader.newParseErrorWith("Too many digits detected in number", len, "Too many digits detected in number", end, "");
        }
        int n = offset = buf[0] == '-' ? 1 : 0;
        if (buf[offset] == '0' && end > offset + 1 && buf[offset + 1] >= '0' && buf[offset + 1] <= '9') {
            throw reader.newParseErrorAt("Leading zero is not allowed. Error parsing number", len + (withQuotes ? 2 : 0));
        }
        try {
            return Double.parseDouble(new String(buf, 0, end));
        }
        catch (NumberFormatException nfe) {
            throw reader.newParseErrorAt("Error parsing number", len + (withQuotes ? 2 : 0), nfe);
        }
    }

    static BigDecimal deserializeDecimal(JParser reader) {
        if (reader.currentToken() == 34) {
            int len = reader.parseString();
            return NumberParser.parseNumberGeneric(reader.chars, len, reader, true);
        }
        int start = reader.scanNumber();
        int end = reader.getCurrentIndex();
        if (end == reader.length()) {
            NumberInfo info = NumberParser.readLongNumber(reader, start);
            return NumberParser.parseNumberGeneric(info.buffer, info.length, reader, false);
        }
        int len = end - start;
        if (len > 18) {
            return NumberParser.parseNumberGeneric(reader.prepareBuffer(start, len), len, reader, false);
        }
        byte[] buf = reader.buffer;
        byte ch = buf[start];
        if (ch == 45) {
            return NumberParser.parseNegativeDecimal(buf, reader, start, end);
        }
        return NumberParser.parsePositiveDecimal(buf, reader, start, end);
    }

    private static BigDecimal parsePositiveDecimal(byte[] buf, JParser reader, int start, int end) {
        int i;
        boolean leadingZero;
        long value = 0L;
        int ch = 32;
        boolean bl = leadingZero = buf[start] == 48;
        for (i = start; i < end && (ch = buf[i]) != 46 && ch != 101 && ch != 69; ++i) {
            int ind = ch - 48;
            if (ind < 0 || ind > 9) {
                if (leadingZero && i > start + 1) {
                    NumberParser.numberException(reader, start, end, "Leading zero is not allowed");
                }
                if (i > start && reader.allWhitespace(i, end)) {
                    return BigDecimal.valueOf(value);
                }
                NumberParser.numberException(reader, start, end, "Unknown digit", Character.valueOf((char)ch));
            }
            value = (value << 3) + (value << 1) + (long)ind;
        }
        if (i == start) {
            NumberParser.numberException(reader, start, end, "Digit not found");
        } else if (leadingZero && ch != 46 && i > start + 1) {
            NumberParser.numberException(reader, start, end, "Leading zero is not allowed");
        } else {
            if (i == end) {
                return BigDecimal.valueOf(value);
            }
            if (ch == 46) {
                if (++i == end) {
                    NumberParser.numberException(reader, start, end, "Number ends with a dot");
                }
                int dp = i;
                while (i < end && (ch = buf[i]) != 101 && ch != 69) {
                    int ind = ch - 48;
                    if (ind < 0 || ind > 9) {
                        if (reader.allWhitespace(i, end)) {
                            return BigDecimal.valueOf(value, i - dp);
                        }
                        NumberParser.numberException(reader, start, end, "Unknown digit", Character.valueOf((char)ch));
                    }
                    value = (value << 3) + (value << 1) + (long)ind;
                    ++i;
                }
                if (i == end) {
                    return BigDecimal.valueOf(value, end - dp);
                }
                if (ch == 101 || ch == 69) {
                    int ep = i++;
                    ch = buf[i];
                    int exp = ch == 45 ? NumberParser.parseNegativeInt(buf, reader, i, end) : (ch == 43 ? NumberParser.parsePositiveInt(buf, reader, i, end, 1) : NumberParser.parsePositiveInt(buf, reader, i, end, 0));
                    return BigDecimal.valueOf(value, ep - dp - exp);
                }
                return BigDecimal.valueOf(value, end - dp);
            }
            if (ch == 101 || ch == 69) {
                int exp = (ch = buf[++i]) == 45 ? NumberParser.parseNegativeInt(buf, reader, i, end) : (ch == 43 ? NumberParser.parsePositiveInt(buf, reader, i, end, 1) : NumberParser.parsePositiveInt(buf, reader, i, end, 0));
                return BigDecimal.valueOf(value, -exp);
            }
        }
        return BigDecimal.valueOf(value);
    }

    private static BigDecimal parseNegativeDecimal(byte[] buf, JParser reader, int start, int end) {
        int i;
        boolean leadingZero;
        long value = 0L;
        int ch = 32;
        boolean bl = leadingZero = buf[start + 1] == 48;
        for (i = start + 1; i < end && (ch = buf[i]) != 46 && ch != 101 && ch != 69; ++i) {
            int ind = ch - 48;
            if (ind < 0 || ind > 9) {
                if (leadingZero && i > start + 2) {
                    NumberParser.numberException(reader, start, end, "Leading zero is not allowed");
                }
                if (i > start + 1 && reader.allWhitespace(i, end)) {
                    return BigDecimal.valueOf(value);
                }
                NumberParser.numberException(reader, start, end, "Unknown digit", Character.valueOf((char)ch));
            }
            value = (value << 3) + (value << 1) - (long)ind;
        }
        if (i == start + 1) {
            NumberParser.numberException(reader, start, end, "Digit not found");
        } else if (leadingZero && ch != 46 && i > start + 2) {
            NumberParser.numberException(reader, start, end, "Leading zero is not allowed");
        } else {
            if (i == end) {
                return BigDecimal.valueOf(value);
            }
            if (ch == 46) {
                if (++i == end) {
                    NumberParser.numberException(reader, start, end, "Number ends with a dot");
                }
                int dp = i;
                while (i < end && (ch = buf[i]) != 101 && ch != 69) {
                    int ind = ch - 48;
                    if (ind < 0 || ind > 9) {
                        if (reader.allWhitespace(i, end)) {
                            return BigDecimal.valueOf(value, i - dp);
                        }
                        NumberParser.numberException(reader, start, end, "Unknown digit", Character.valueOf((char)ch));
                    }
                    value = (value << 3) + (value << 1) - (long)ind;
                    ++i;
                }
                if (i == end) {
                    return BigDecimal.valueOf(value, end - dp);
                }
                if (ch == 101 || ch == 69) {
                    int ep = i++;
                    ch = buf[i];
                    int exp = ch == 45 ? NumberParser.parseNegativeInt(buf, reader, i, end) : (ch == 43 ? NumberParser.parsePositiveInt(buf, reader, i, end, 1) : NumberParser.parsePositiveInt(buf, reader, i, end, 0));
                    return BigDecimal.valueOf(value, ep - dp - exp);
                }
                return BigDecimal.valueOf(value, end - dp);
            }
            if (ch == 101 || ch == 69) {
                int exp = (ch = buf[++i]) == 45 ? NumberParser.parseNegativeInt(buf, reader, i, end) : (ch == 43 ? NumberParser.parsePositiveInt(buf, reader, i, end, 1) : NumberParser.parsePositiveInt(buf, reader, i, end, 0));
                return BigDecimal.valueOf(value, -exp);
            }
        }
        return BigDecimal.valueOf(value);
    }

    private static BigInteger parseBigIntGeneric(char[] buf, int len, JParser reader) {
        int end;
        for (end = len; end > 0 && Character.isWhitespace(buf[end - 1]); --end) {
        }
        if (end > reader.maxNumberDigits) {
            throw reader.newParseErrorWith("Too many digits detected in number", len, "Too many digits detected in number", end, "");
        }
        try {
            return new BigInteger(new String(buf, 0, end));
        }
        catch (NumberFormatException var5) {
            throw reader.newParseErrorAt("Error parsing number", len, var5);
        }
    }

    static BigInteger deserializeBigInt(JParser reader) {
        if (reader.currentToken() == 34) {
            int start = reader.parseString();
            return NumberParser.parseBigIntGeneric(reader.chars, start, reader);
        }
        int start = reader.scanNumber();
        int end = reader.getCurrentIndex();
        int len = end - start;
        if (len > 18) {
            end = reader.findNonWhitespace(end);
            len = end - start;
            if (end == reader.length()) {
                NumberInfo info = NumberParser.readLongNumber(reader, start);
                return NumberParser.parseBigIntGeneric(info.buffer, info.length, reader);
            }
            if (len > 18) {
                return NumberParser.parseBigIntGeneric(reader.prepareBuffer(start, len), len, reader);
            }
        }
        byte[] buf = reader.buffer;
        byte ch = buf[start];
        int i = start;
        long value = 0L;
        if (ch == 45) {
            i = start + 1;
            if (i == end) {
                NumberParser.numberException(reader, start, end, "Digit not found");
            }
            while (i < end) {
                int ind = buf[i] - 48;
                if (ind < 0 || ind > 9) {
                    if (i > start + 1 && reader.allWhitespace(i, end)) {
                        return BigInteger.valueOf(value);
                    }
                    NumberParser.numberException(reader, start, end, "Unknown digit", Character.valueOf((char)ch));
                }
                value = (value << 3) + (value << 1) - (long)ind;
                ++i;
            }
            return BigInteger.valueOf(value);
        }
        if (start == end) {
            NumberParser.numberException(reader, start, end, "Digit not found");
        }
        while (i < end) {
            int ind = buf[i] - 48;
            if (ind < 0 || ind > 9) {
                if (ch == 43 && i > start + 1 && reader.allWhitespace(i, end)) {
                    return BigInteger.valueOf(value);
                }
                if (ch != 43 && i > start && reader.allWhitespace(i, end)) {
                    return BigInteger.valueOf(value);
                }
                NumberParser.numberException(reader, start, end, "Unknown digit", Character.valueOf((char)ch));
            }
            value = (value << 3) + (value << 1) + (long)ind;
            ++i;
        }
        return BigInteger.valueOf(value);
    }

    private static class NumberInfo {
        final char[] buffer;
        final int length;

        NumberInfo(char[] buffer, int length) {
            this.buffer = buffer;
            this.length = length;
        }
    }
}

