/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.stream.core;

import io.avaje.json.stream.JsonOutput;
import io.avaje.json.stream.core.BufferRecycler;
import io.avaje.json.stream.core.JGenerator;
import io.avaje.json.stream.core.JParser;
import io.avaje.json.stream.core.JsonGenerator;
import io.avaje.json.stream.core.JsonParser;
import java.io.InputStream;

final class Recyclers {
    static final int GENERATOR_BUFFER_SIZE = Integer.getInteger("jsonb.generatorBufferSize", 4096);
    static final int PARSER_BUFFER_SIZE = Integer.getInteger("jsonb.parserBufferSize", 4096);
    static final int PARSER_CHAR_BUFFER_SIZE = Integer.getInteger("jsonb.parserCharBufferSize", 4096);

    private Recyclers() {
    }

    private static JGenerator createGenerator() {
        return new JGenerator(GENERATOR_BUFFER_SIZE);
    }

    private static JParser createParser() {
        char[] ch = new char[PARSER_CHAR_BUFFER_SIZE];
        byte[] by = new byte[PARSER_BUFFER_SIZE];
        return new JParser(ch, by, 0, JParser.ErrorInfo.MINIMAL, JParser.DoublePrecision.DEFAULT, JParser.UnknownNumberParsing.BIGDECIMAL, 100, 50000);
    }

    static final class NonRecyclingPool
    implements BufferRecycler {
        private static final BufferRecycler GLOBAL = new NonRecyclingPool();

        private NonRecyclingPool() {
        }

        static BufferRecycler shared() {
            return GLOBAL;
        }

        @Override
        public JsonGenerator generator(JsonOutput target) {
            return Recyclers.createGenerator().prepare(target);
        }

        @Override
        public JsonParser parser(byte[] bytes) {
            return Recyclers.createParser().process(bytes, bytes.length);
        }

        @Override
        public JsonParser parser(InputStream in) {
            return Recyclers.createParser().process(in);
        }

        @Override
        public void recycle(JsonGenerator recycler) {
        }

        @Override
        public void recycle(JsonParser recycler) {
        }
    }

    static final class ThreadLocalPool
    implements BufferRecycler {
        private final ThreadLocal<JParser> PARSER = ThreadLocal.withInitial(() -> Recyclers.createParser());
        private final ThreadLocal<JGenerator> GENERATOR = ThreadLocal.withInitial(() -> Recyclers.createGenerator());
        private static final BufferRecycler GLOBAL = new ThreadLocalPool();

        static BufferRecycler shared() {
            return GLOBAL;
        }

        private ThreadLocalPool() {
        }

        @Override
        public JsonGenerator generator(JsonOutput target) {
            return this.GENERATOR.get().prepare(target);
        }

        @Override
        public JsonParser parser(byte[] bytes) {
            return this.PARSER.get().process(bytes, bytes.length);
        }

        @Override
        public JsonParser parser(InputStream in) {
            return this.PARSER.get().process(in);
        }

        @Override
        public void recycle(JsonGenerator recycler) {
        }

        @Override
        public void recycle(JsonParser recycler) {
        }
    }
}

