/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.Append;
import io.avaje.jsonb.generator.GenericType;
import io.avaje.jsonb.generator.MethodReader;
import io.avaje.jsonb.generator.NamingConvention;
import io.avaje.jsonb.generator.PrimitiveUtil;
import io.avaje.jsonb.generator.PropertyIgnoreReader;
import io.avaje.jsonb.generator.PropertyReader;
import io.avaje.jsonb.generator.TypeSubTypeMeta;
import io.avaje.jsonb.generator.Util;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;

class FieldReader {
    private final Map<String, TypeSubTypeMeta> subTypes = new LinkedHashMap<String, TypeSubTypeMeta>();
    private final boolean publicField;
    private final String rawType;
    private final GenericType genericType;
    private final String adapterFieldName;
    private final String adapterShortType;
    private final String fieldName;
    private final boolean primitive;
    private final String defaultValue;
    private final String propertyName;
    private final boolean serialize;
    private final boolean deserialize;
    private final boolean unmapped;
    private final boolean raw;
    private MethodReader setter;
    private MethodReader getter;
    private int position;
    private boolean constructorParam;

    FieldReader(Element element, NamingConvention namingConvention, TypeSubTypeMeta subType) {
        this.addSubType(subType);
        this.fieldName = element.getSimpleName().toString();
        this.propertyName = PropertyReader.name(namingConvention, this.fieldName, element);
        this.publicField = element.getModifiers().contains((Object)Modifier.PUBLIC);
        this.rawType = FieldReader.trimAnnotations(element.asType().toString());
        PropertyIgnoreReader ignoreReader = new PropertyIgnoreReader(element);
        this.unmapped = ignoreReader.unmapped();
        this.raw = ignoreReader.raw();
        this.serialize = ignoreReader.serialize();
        this.deserialize = ignoreReader.deserialize();
        if (this.raw) {
            this.genericType = GenericType.parse("java.lang.String");
            this.adapterShortType = "JsonAdapter<String>";
            this.adapterFieldName = "rawAdapter";
            this.defaultValue = "null";
            this.primitive = false;
        } else if (this.unmapped) {
            this.genericType = GenericType.parse("java.lang.Object");
            this.adapterShortType = "JsonAdapter<Object>";
            this.adapterFieldName = "objectJsonAdapter";
            this.defaultValue = "null";
            this.primitive = false;
        } else {
            this.genericType = GenericType.parse(this.rawType);
            String shortType = this.genericType.shortType();
            this.primitive = PrimitiveUtil.isPrimitive(shortType);
            this.defaultValue = !this.primitive ? "null" : PrimitiveUtil.defaultValue(shortType);
            String typeWrapped = PrimitiveUtil.wrap(shortType);
            this.adapterShortType = "JsonAdapter<" + typeWrapped + ">";
            this.adapterFieldName = (this.primitive ? "p" : "") + Util.initLower(this.genericType.shortName()) + "JsonAdapter";
        }
    }

    static String trimAnnotations(String type) {
        int pos = type.indexOf("@");
        if (pos == -1) {
            return type;
        }
        return type.substring(0, pos) + type.substring(type.lastIndexOf(32) + 1);
    }

    void position(int pos) {
        this.position = pos;
    }

    String fieldName() {
        return this.fieldName;
    }

    String propertyName() {
        return this.propertyName;
    }

    boolean typeObjectBooleanWithIsPrefix() {
        return this.nameHasIsPrefix() && this.genericType.topType().equals("java.lang.Boolean");
    }

    boolean typeBooleanWithIsPrefix() {
        return this.nameHasIsPrefix() && (this.genericType.topType().equals("boolean") || this.genericType.topType().equals("java.lang.Boolean"));
    }

    private boolean nameHasIsPrefix() {
        return this.fieldName.length() > 2 && this.fieldName.startsWith("is") && Character.isUpperCase(this.fieldName.charAt(2));
    }

    boolean isRaw() {
        return this.raw;
    }

    boolean isUnmapped() {
        return this.unmapped;
    }

    boolean include() {
        return this.serialize || this.deserialize;
    }

    boolean includeFromJson() {
        return this.deserialize;
    }

    boolean includeToJson() {
        return this.serialize;
    }

    boolean includeToJson(String type) {
        return this.serialize && (type == null || this.subTypes.containsKey(type));
    }

    void addSubType(TypeSubTypeMeta currentSubType) {
        if (currentSubType != null) {
            this.subTypes.put(currentSubType.type(), currentSubType);
        }
    }

    boolean includeForType(TypeSubTypeMeta subType) {
        return this.subTypes.containsKey(subType.type());
    }

    void addImports(Set<String> importTypes) {
        if (this.unmapped) {
            importTypes.add("java.util.*");
        }
        if (!this.raw) {
            this.genericType.addImports(importTypes);
        }
    }

    void cascadeTypes(Set<String> types) {
        if (!this.raw && !this.unmapped) {
            String topType = this.genericType.topType();
            if ("java.util.List".equals(topType) || "java.util.Set".equals(topType)) {
                types.add(this.genericType.firstParamType());
            } else if ("java.util.Map".equals(topType)) {
                types.add(this.genericType.secondParamType());
            } else {
                types.add(topType);
            }
        }
    }

    void setterMethod(MethodReader setter) {
        this.setter = setter;
    }

    void getterMethod(MethodReader getter) {
        this.getter = getter;
    }

    void constructorParam() {
        this.constructorParam = true;
    }

    boolean isPublicField() {
        return this.publicField;
    }

    void writeDebug(Append writer) {
        writer.append("  // %s [%s] name:%s", this.fieldName, this.rawType, this.propertyName);
        if (!this.serialize) {
            writer.append(" ignoreSerialize");
        }
        if (!this.deserialize) {
            writer.append(" ignoreDeserialize");
        } else if (this.constructorParam) {
            writer.append(" constructor");
        } else if (this.setter != null) {
            writer.append(" setter:%s ", this.setter);
        } else if (this.publicField) {
            writer.append(" publicField");
        } else {
            writer.append(" ERROR?? no constructor, setter and not a public field?");
        }
        if (!this.subTypes.isEmpty()) {
            writer.append(" subTypes %s", this.subTypes.keySet());
        }
        writer.eol();
    }

    String adapterShortType() {
        return this.genericType.shortType();
    }

    void writeField(Append writer) {
        writer.append("  private final %s %s;", this.adapterShortType, this.adapterFieldName).eol();
    }

    void writeConstructor(Append writer) {
        if (this.raw) {
            writer.append("    this.%s = jsonb.rawAdapter();", this.adapterFieldName).eol();
        } else {
            String asType = this.genericType.asTypeDeclaration();
            writer.append("    this.%s = jsonb.adapter(%s);", this.adapterFieldName, asType).eol();
        }
    }

    void writeToJson(Append writer, String varName, String prefix) {
        if (this.unmapped) {
            writer.append("%sMap<String, Object> unmapped = ", prefix);
            this.writeGetValue(writer, varName, ";");
            writer.eol();
            writer.append("%sif (unmapped != null) {", prefix).eol();
            writer.append("%s for (Map.Entry<String, Object> entry : unmapped.entrySet()) {", prefix).eol();
            writer.append("%s   writer.name(entry.getKey());", prefix).eol();
            writer.append("%s   objectJsonAdapter.toJson(writer, entry.getValue());", prefix).eol();
            writer.append("%s }", prefix).eol();
            writer.append("%s}", prefix).eol();
        } else {
            writer.append("%swriter.name(%s);", prefix, this.position).eol();
            writer.append("%s%s.toJson(writer, ", prefix, this.adapterFieldName);
            this.writeGetValue(writer, varName, ");");
            writer.eol();
        }
    }

    private void writeGetValue(Append writer, String varName, String suffix) {
        if (this.getter != null) {
            writer.append("%s.%s()%s", varName, this.getter.getName(), suffix);
        } else if (this.publicField) {
            writer.append("%s.%s%s", varName, this.fieldName, suffix);
        } else {
            writer.append("FIXME: field %s is not public and has not getter ? ", this.fieldName);
        }
    }

    void writeFromJsonVariables(Append writer) {
        if (this.unmapped) {
            return;
        }
        writer.append("    %s _val$%s = %s;", this.pad(this.genericType.shortType()), this.fieldName, this.defaultValue);
        if (!this.constructorParam) {
            writer.append(" boolean _set$%s = false;", this.fieldName);
        }
        writer.eol();
    }

    private String pad(String value) {
        int pad = 10 - value.length();
        if (pad < 1) {
            return value;
        }
        StringBuilder sb = new StringBuilder(10).append(value);
        for (int i = 0; i < pad; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    void writeFromJsonSwitch(Append writer, boolean defaultConstructor, String varName) {
        if (this.unmapped) {
            return;
        }
        writer.append("        case \"%s\": {", this.propertyName).eol();
        if (!this.deserialize) {
            writer.append("          reader.skipValue();");
        } else if (defaultConstructor) {
            if (this.setter != null) {
                writer.append("          _$%s.%s(%s.fromJson(reader));", varName, this.setter.getName(), this.adapterFieldName);
            } else if (this.publicField) {
                writer.append("          _$%s.%s = %s.fromJson(reader);", varName, this.fieldName, this.adapterFieldName);
            }
        } else {
            writer.append("          _val$%s = %s.fromJson(reader);", this.fieldName, this.adapterFieldName);
            if (!this.constructorParam) {
                writer.append(" _set$%s = true;", this.fieldName);
            }
        }
        writer.append(" break;").eol();
        writer.append("        }").eol();
    }

    void writeFromJsonSetter(Append writer, String varName, String prefix) {
        if (this.unmapped) {
            this.writeFromJsonUnmapped(writer, varName);
            return;
        }
        if (this.setter != null) {
            writer.append("%s    if (_set$%s) _$%s.%s(_val$%s);", prefix, this.fieldName, varName, this.setter.getName(), this.fieldName).eol();
        } else if (this.publicField) {
            writer.append("%s    if (_set$%s) _$%s.%s = _val$%s;", prefix, this.fieldName, varName, this.fieldName, this.fieldName).eol();
        }
    }

    void writeFromJsonUnmapped(Append writer, String varName) {
        if (this.setter != null) {
            writer.append("    _$%s.%s(unmapped);", varName, this.setter.getName()).eol();
        } else if (this.publicField) {
            writer.append("    _$%s.%s = unmapped;", varName, this.fieldName).eol();
        }
    }

    void writeViewBuilder(Append writer, String shortName) {
        if (this.getter == null) {
            writer.append("    builder.add(\"%s\", %s, builder.field(%s.class, \"%s\"));", this.propertyName, this.adapterFieldName, shortName, this.fieldName).eol();
        } else {
            String topType = this.genericType.topType();
            writer.append("    builder.add(\"%s\", %s, builder.method(%s.class, \"%s\", %s.class));", this.propertyName, this.adapterFieldName, shortName, this.getter.getName(), topType).eol();
        }
    }
}

