/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

class ImportReader {
    private static final String JSON_IMPORT = "io.avaje.jsonb.Json.Import";
    private static final String JSON_MIXIN = "io.avaje.jsonb.Json.MixIn";

    ImportReader() {
    }

    List<String> read(Element element) {
        ArrayList<String> fullNames = new ArrayList<String>();
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!JSON_IMPORT.equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                for (Object importType : (List)entry.getValue().getValue()) {
                    fullNames.add(Util.trimClassSuffix(importType.toString()));
                }
            }
        }
        return fullNames;
    }

    String readMixin(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            Iterator<Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> iterator;
            if (!JSON_MIXIN.equals(annotationMirror.getAnnotationType().toString()) || !(iterator = annotationMirror.getElementValues().entrySet().iterator()).hasNext()) continue;
            Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry = iterator.next();
            return Util.trimClassSuffix(entry.getValue().toString());
        }
        return null;
    }
}

