/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import java.io.IOException;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

class ProcessingContext {
    private final ProcessingEnvironment processingEnv;
    private final Messager messager;
    private final Filer filer;
    private final Elements elementUtils;
    private final Types typeUtils;

    ProcessingContext(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
        this.elementUtils = processingEnv.getElementUtils();
        this.typeUtils = processingEnv.getTypeUtils();
    }

    void logError(Element e, String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    void logError(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args));
    }

    void logWarn(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, String.format(msg, args));
    }

    void logDebug(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
    }

    JavaFileObject createWriter(String cls) throws IOException {
        return this.filer.createSourceFile(cls, new Element[0]);
    }

    FileObject createMetaInfWriterFor(String interfaceType) throws IOException {
        return this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", interfaceType, new Element[0]);
    }

    TypeElement element(String rawType) {
        return this.elementUtils.getTypeElement(rawType);
    }

    Element asElement(TypeMirror returnType) {
        return this.typeUtils.asElement(returnType);
    }

    ProcessingEnvironment env() {
        return this.processingEnv;
    }
}

