/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.Append;
import io.avaje.jsonb.generator.BeanReader;
import io.avaje.jsonb.generator.FieldReader;
import io.avaje.jsonb.generator.MethodReader;
import io.avaje.jsonb.generator.Util;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.TypeElement;

class TypeSubTypeMeta {
    private String type;
    private String name;
    private TypeElement typeElement;
    private boolean defaultPublicConstructor;
    private final List<MethodReader> publicConstructors = new ArrayList<MethodReader>();
    private final Set<String> constructorFieldNames = new LinkedHashSet<String>();

    TypeSubTypeMeta() {
    }

    public String toString() {
        return this.type;
    }

    void add(String key, String val) {
        if (key.equals("type()")) {
            this.type = Util.trimClassSuffix(val);
        } else if (key.equals("name()")) {
            this.name = Util.trimQuotes(val);
        }
    }

    void setElement(TypeElement element) {
        this.typeElement = element;
    }

    TypeElement element() {
        return this.typeElement;
    }

    String type() {
        return this.type;
    }

    String name() {
        if (this.name == null) {
            this.name = Util.shortName(this.type);
        }
        return this.name;
    }

    void addConstructor(MethodReader methodReader) {
        if (methodReader.getParams().isEmpty()) {
            this.defaultPublicConstructor = true;
        }
        this.publicConstructors.add(methodReader);
    }

    void writeFromJsonBuild(Append writer, String varName, BeanReader beanReader) {
        writer.append("    if (\"%s\".equals(type)) {", this.name()).eol();
        this.writeFromJsonConstructor(writer, varName, beanReader);
        this.writeFromJsonSetters(writer, varName, beanReader);
        writer.append("      return _$%s;", varName).eol();
        writer.append("    }").eol();
    }

    private void writeFromJsonSetters(Append writer, String varName, BeanReader beanReader) {
        for (FieldReader field : beanReader.allFields()) {
            if (!this.isIncludeSetter(field)) continue;
            field.writeFromJsonSetter(writer, varName, "  ");
        }
    }

    private boolean isIncludeSetter(FieldReader field) {
        return field.includeFromJson() && !this.constructorFieldNames.contains(field.fieldName()) && field.includeForType(this);
    }

    private void writeFromJsonConstructor(Append writer, String varName, BeanReader beanReader) {
        writer.append("      %s _$%s = new %s(", this.type, varName, this.type);
        MethodReader constructor = this.findConstructor();
        if (constructor != null) {
            List<MethodReader.MethodParam> params = constructor.getParams();
            int size = params.size();
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    writer.append(", ");
                }
                String paramName = params.get(i).name();
                this.constructorFieldNames.add(paramName);
                writer.append(beanReader.constructorParamName(paramName));
            }
        }
        writer.append(");").eol();
    }

    private MethodReader findConstructor() {
        if (this.defaultPublicConstructor || this.publicConstructors.isEmpty()) {
            return null;
        }
        return this.publicConstructors.get(0);
    }
}

