/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.Json;
import io.avaje.jsonb.generator.Append;
import io.avaje.jsonb.generator.FieldReader;
import io.avaje.jsonb.generator.MethodReader;
import io.avaje.jsonb.generator.NamingConvention;
import io.avaje.jsonb.generator.NamingConventionReader;
import io.avaje.jsonb.generator.ProcessingContext;
import io.avaje.jsonb.generator.TypeReader;
import io.avaje.jsonb.generator.TypeSubTypeMeta;
import io.avaje.jsonb.generator.Util;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

class BeanReader {
    private final TypeElement beanType;
    private final String shortName;
    private final String type;
    private final MethodReader constructor;
    private final List<FieldReader> allFields;
    private final Set<String> importTypes = new TreeSet<String>();
    private final NamingConvention namingConvention;
    private final boolean hasSubTypes;
    private final TypeReader typeReader;
    private final String typeProperty;
    private final boolean nonAccessibleField;
    private final boolean caseInsensitiveKeys;
    private FieldReader unmappedField;
    private boolean hasRaw;
    private final boolean isRecord;

    BeanReader(TypeElement beanType, ProcessingContext context) {
        this.beanType = beanType;
        this.type = beanType.getQualifiedName().toString();
        this.shortName = this.shortName(beanType);
        NamingConventionReader ncReader = new NamingConventionReader(beanType);
        this.namingConvention = ncReader.get();
        this.typeProperty = ncReader.typeProperty();
        this.caseInsensitiveKeys = ncReader.isCaseInsensitiveKeys();
        this.typeReader = new TypeReader(beanType, context, this.namingConvention);
        this.typeReader.process();
        this.nonAccessibleField = this.typeReader.nonAccessibleField();
        this.hasSubTypes = this.typeReader.hasSubTypes();
        this.allFields = this.typeReader.allFields();
        this.constructor = this.typeReader.constructor();
        this.isRecord = this.isRecord(beanType);
    }

    public BeanReader(TypeElement beanType, TypeElement mixInElement, ProcessingContext context) {
        this.beanType = beanType;
        this.type = beanType.getQualifiedName().toString();
        this.shortName = this.shortName(beanType);
        NamingConventionReader ncReader = new NamingConventionReader(beanType);
        this.namingConvention = ncReader.get();
        this.typeProperty = ncReader.typeProperty();
        this.caseInsensitiveKeys = ncReader.isCaseInsensitiveKeys();
        this.typeReader = new TypeReader(beanType, mixInElement, context, this.namingConvention);
        this.typeReader.process();
        this.nonAccessibleField = this.typeReader.nonAccessibleField();
        this.hasSubTypes = this.typeReader.hasSubTypes();
        this.allFields = this.typeReader.allFields();
        this.constructor = this.typeReader.constructor();
        this.isRecord = this.isRecord(beanType);
    }

    boolean isRecord(TypeElement beanType) {
        try {
            List recordComponents = (List)TypeElement.class.getMethod("getRecordComponents", new Class[0]).invoke((Object)beanType, new Object[0]);
            return !recordComponents.isEmpty();
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return false;
        }
    }

    int genericTypeParamsCount() {
        return this.typeReader.genericTypeParamsCount();
    }

    public String toString() {
        return this.beanType.toString();
    }

    String shortName() {
        return this.shortName;
    }

    TypeElement getBeanType() {
        return this.beanType;
    }

    List<FieldReader> allFields() {
        return this.allFields;
    }

    boolean hasSubtypes() {
        return this.hasSubTypes;
    }

    boolean nonAccessibleField() {
        return this.nonAccessibleField;
    }

    boolean hasJsonAnnotation() {
        return this.beanType.getAnnotation(Json.class) != null;
    }

    void read() {
        for (FieldReader field : this.allFields) {
            field.addImports(this.importTypes);
            if (field.isRaw()) {
                this.hasRaw = true;
            }
            if (!field.isUnmapped()) continue;
            this.unmappedField = field;
        }
    }

    private String shortName(Element element) {
        return element.getSimpleName().toString();
    }

    private Set<String> importTypes() {
        if (this.genericTypeParamsCount() > 0) {
            this.importTypes.add("java.lang.reflect.Type");
            this.importTypes.add("java.lang.reflect.ParameterizedType");
        }
        this.importTypes.add("io.avaje.jsonb.*");
        this.importTypes.add("java.io.IOException");
        this.importTypes.add("io.avaje.jsonb.spi.*");
        if (!this.hasSubTypes) {
            this.importTypes.add("java.lang.invoke.MethodHandle");
        }
        if (Util.validImportType(this.type)) {
            this.importTypes.add(this.type);
        }
        for (FieldReader allField : this.allFields) {
            allField.addImports(this.importTypes);
        }
        return this.importTypes;
    }

    void writeImports(Append writer) {
        for (String importType : this.importTypes()) {
            if (!Util.validImportType(importType)) continue;
            writer.append("import %s;", importType).eol();
        }
        writer.eol();
    }

    void cascadeTypes(Set<String> types) {
        for (FieldReader allField : this.allFields) {
            if (!allField.include()) continue;
            allField.cascadeTypes(types);
        }
    }

    void writeFields(Append writer) {
        writer.append("  // naming convention %s", this.namingConvention).eol();
        for (FieldReader allField : this.allFields) {
            allField.writeDebug(writer);
        }
        writer.eol();
        if (this.hasRaw) {
            writer.append("  private final JsonAdapter<String> rawAdapter;").eol();
        }
        HashSet<String> uniqueTypes = new HashSet<String>();
        for (FieldReader allField : this.allFields) {
            if (!allField.include() || allField.isRaw() || !uniqueTypes.add(allField.adapterShortType())) continue;
            allField.writeField(writer);
        }
        writer.append("  private final PropertyNames names;").eol();
        writer.eol();
    }

    void writeConstructor(Append writer) {
        if (this.hasRaw) {
            writer.append("    this.rawAdapter = jsonb.rawAdapter();").eol();
        }
        HashSet<String> uniqueTypes = new HashSet<String>();
        for (FieldReader allField : this.allFields) {
            if (!allField.include() || allField.isRaw() || !uniqueTypes.add(allField.adapterShortType())) continue;
            allField.writeConstructor(writer);
        }
        writer.append("    this.names = jsonb.properties(");
        if (this.hasSubTypes) {
            writer.append("\"").append(this.typeProperty).append("\", ");
        }
        int size = this.allFields.size();
        for (int i = 0; i < size; ++i) {
            FieldReader fieldReader = this.allFields.get(i);
            if (i > 0) {
                writer.append(", ");
            }
            writer.append("\"").append(fieldReader.propertyName()).append("\"");
        }
        writer.append(");").eol();
    }

    void writeViewSupport(Append writer) {
        if (!this.hasSubTypes) {
            this.writeView(writer);
            this.writeViewBuild(writer);
        }
    }

    private void writeView(Append writer) {
        writer.eol();
        writer.append("  @Override").eol();
        writer.append("  public boolean isViewBuilderAware() {").eol();
        writer.append("    return true;").eol();
        writer.append("  }").eol().eol();
        writer.append("  @Override").eol();
        writer.append("  public ViewBuilderAware viewBuild() {").eol();
        writer.append("    return this;").eol();
        writer.append("  }").eol().eol();
    }

    private void writeViewBuild(Append writer) {
        writer.append("  @Override").eol();
        writer.append("  public void build(ViewBuilder builder, String name, MethodHandle handle) {").eol();
        writer.append("    builder.beginObject(name, handle);").eol();
        if (!this.hasSubTypes) {
            for (FieldReader allField : this.allFields) {
                if (!allField.includeToJson(null)) continue;
                allField.writeViewBuilder(writer, this.shortName);
            }
        }
        writer.append("    builder.endObject();").eol();
        writer.append("  }").eol();
    }

    void writeToJson(Append writer) {
        String varName = Util.initLower(this.shortName);
        writer.eol();
        writer.append("  @Override").eol();
        writer.append("  public void toJson(JsonWriter writer, %s %s) {", this.shortName, varName).eol();
        writer.append("    writer.beginObject();").eol();
        writer.append("    writer.names(names);").eol();
        if (this.hasSubTypes) {
            this.writeToJsonForSubtypes(writer, varName);
        } else {
            this.writeToJsonForType(writer, varName, "    ", null);
        }
        writer.append("    writer.endObject();").eol();
        writer.append("  }").eol();
    }

    private void writeToJsonForSubtypes(Append writer, String varName) {
        if (this.hasSubTypes) {
            List<TypeSubTypeMeta> subTypes = this.typeReader.subTypes();
            for (int i = 0; i < subTypes.size(); ++i) {
                TypeSubTypeMeta subTypeMeta = subTypes.get(i);
                String subType = subTypeMeta.type();
                String subTypeName = subTypeMeta.name();
                String elseIf = i == 0 ? "if" : "else if";
                writer.append("    %s (%s instanceof %s) {", elseIf, varName, subType).eol();
                writer.append("      %s sub = (%s)%s;", subType, subType, varName).eol();
                writer.append("      writer.name(0);").eol();
                writer.append("      stringJsonAdapter.toJson(writer, \"%s\");", subTypeName).eol();
                this.writeToJsonForType(writer, "sub", "      ", subType);
                writer.append("    }").eol();
            }
        }
    }

    private void writeToJsonForType(Append writer, String varName, String prefix, String type) {
        for (FieldReader allField : this.allFields) {
            if (!allField.includeToJson(type)) continue;
            allField.writeToJson(writer, varName, prefix);
        }
    }

    void writeFromJson(Append writer) {
        boolean directLoad;
        String varName = Util.initLower(this.shortName);
        writer.eol();
        writer.append("  @Override").eol();
        writer.append("  public %s fromJson(JsonReader reader) {", this.shortName, varName).eol();
        boolean bl = directLoad = this.constructor == null && !this.hasSubTypes;
        if (directLoad) {
            writer.append("    %s _$%s = new %s();", this.shortName, varName, this.shortName).eol();
        } else {
            writer.append("    // variables to read json values into, constructor params don't need _set$ flags").eol();
            for (FieldReader allField : this.allFields) {
                if (this.isRecord) {
                    allField.writeFromJsonVariablesRecord(writer);
                    continue;
                }
                if (!allField.includeFromJson()) continue;
                allField.writeFromJsonVariables(writer);
            }
        }
        if (this.hasSubTypes) {
            writer.eol().append("    String type = null;").eol();
        }
        if (this.unmappedField != null) {
            writer.append("    Map<String, Object> unmapped = new LinkedHashMap<>();").eol();
        }
        this.writeFromJsonSwitch(writer, directLoad, varName);
        writer.eol();
        if (this.hasSubTypes) {
            this.writeFromJsonWithSubTypes(writer, varName);
            return;
        }
        if (!directLoad) {
            this.writeJsonBuildResult(writer, varName);
        } else if (this.unmappedField != null) {
            writer.append("   // unmappedField... ", varName).eol();
            this.unmappedField.writeFromJsonUnmapped(writer, varName);
        }
        writer.append("    return _$%s;", varName).eol();
        writer.append("  }").eol();
    }

    private void writeJsonBuildResult(Append writer, String varName) {
        writer.append("    // build and return %s", this.shortName).eol();
        writer.append("    %s _$%s = new %s(", this.shortName, varName, this.shortName);
        List<MethodReader.MethodParam> params = this.constructor.getParams();
        int size = params.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                writer.append(", ");
            }
            writer.append(this.constructorParamName(params.get(i).name()));
        }
        writer.append(");").eol();
        for (FieldReader allField : this.allFields) {
            if (!allField.includeFromJson()) continue;
            allField.writeFromJsonSetter(writer, varName, "");
        }
    }

    private void writeFromJsonWithSubTypes(Append writer, String varName) {
        writer.append("    if (type == null) {").eol();
        writer.append("      throw new IllegalStateException(\"Missing %s property which is required?\");", this.typeProperty).eol();
        writer.append("    }").eol();
        for (TypeSubTypeMeta subTypeMeta : this.typeReader.subTypes()) {
            subTypeMeta.writeFromJsonBuild(writer, varName, this);
        }
        writer.append("    throw new IllegalStateException(\"Unknown value for %s property \" + type);", this.typeProperty).eol();
        writer.append("  }").eol();
    }

    String constructorParamName(String name) {
        if (this.unmappedField != null && this.unmappedField.fieldName().equals(name)) {
            return "unmapped";
        }
        return "_val$" + name;
    }

    private void writeFromJsonSwitch(Append writer, boolean defaultConstructor, String varName) {
        String unmappedFieldName;
        writer.eol();
        writer.append("    // read json").eol();
        writer.append("    reader.beginObject();").eol();
        writer.append("    reader.names(names);").eol();
        writer.append("    while (reader.hasNextField()) {").eol();
        if (this.caseInsensitiveKeys) {
            writer.append("      final String origFieldName = reader.nextField();").eol();
            writer.append("      final String fieldName = origFieldName.toLowerCase();").eol();
        } else {
            writer.append("      final String fieldName = reader.nextField();").eol();
        }
        writer.append("      switch (fieldName) {").eol();
        if (this.hasSubTypes) {
            writer.append("        case \"%s\": {", this.typePropertyKey()).eol();
            writer.append("          type = stringJsonAdapter.fromJson(reader); break;").eol();
            writer.append("        }").eol();
        }
        for (FieldReader allField : this.allFields) {
            allField.writeFromJsonSwitch(writer, defaultConstructor, varName, this.caseInsensitiveKeys);
        }
        writer.append("        default: {").eol();
        String string = unmappedFieldName = this.caseInsensitiveKeys ? "origFieldName" : "fieldName";
        if (this.unmappedField != null) {
            writer.append("          Object value = objectJsonAdapter.fromJson(reader);").eol();
            writer.append("          unmapped.put(%s, value);", unmappedFieldName).eol();
        } else {
            writer.append("          reader.unmappedField(%s);", unmappedFieldName).eol();
            writer.append("          reader.skipValue();").eol();
        }
        writer.append("        }").eol();
        writer.append("      }").eol();
        writer.append("    }").eol();
        writer.append("    reader.endObject();").eol();
    }

    private String typePropertyKey() {
        return this.caseInsensitiveKeys ? this.typeProperty.toLowerCase() : this.typeProperty;
    }
}

