/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.ComponentMetaData;
import io.avaje.jsonb.generator.ProcessingContext;
import io.avaje.jsonb.generator.Util;
import java.io.FileNotFoundException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

class ComponentReader {
    private static final String META_DATA = "io.avaje.jsonb.spi.MetaData";
    private static final String META_DATA_FACTORY = "io.avaje.jsonb.spi.MetaData.Factory";
    private final ProcessingContext ctx;
    private final ComponentMetaData componentMetaData;

    ComponentReader(ProcessingContext ctx, ComponentMetaData metaData) {
        this.ctx = ctx;
        this.componentMetaData = metaData;
    }

    void read() {
        TypeElement moduleType;
        String componentFullName = this.loadMetaInfServices();
        if (componentFullName != null && (moduleType = this.ctx.element(componentFullName)) != null) {
            this.componentMetaData.setFullName(componentFullName);
            this.readMetaData(moduleType);
        }
    }

    private void readMetaData(TypeElement moduleType) {
        for (AnnotationMirror annotationMirror : moduleType.getAnnotationMirrors()) {
            if (META_DATA.equals(annotationMirror.getAnnotationType().toString())) {
                this.readValues(annotationMirror).forEach(this.componentMetaData::add);
                continue;
            }
            if (!META_DATA_FACTORY.equals(annotationMirror.getAnnotationType().toString())) continue;
            this.readValues(annotationMirror).forEach(this.componentMetaData::addFactory);
        }
    }

    private List<String> readValues(AnnotationMirror annotationMirror) {
        ArrayList<String> adapterClasses = new ArrayList<String>();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            for (Object adapterEntry : (List)entry.getValue().getValue()) {
                adapterClasses.add(this.adapterNameFromEntry(adapterEntry));
            }
        }
        return adapterClasses;
    }

    private String adapterNameFromEntry(Object adapterEntry) {
        return Util.trimClassSuffix(adapterEntry.toString());
    }

    private String loadMetaInfServices() {
        List<String> lines = this.loadMetaInf();
        return lines.isEmpty() ? null : lines.get(0);
    }

    private List<String> loadMetaInf() {
        try {
            FileObject fileObject = this.ctx.env().getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/io.avaje.jsonb.Jsonb$GeneratedComponent");
            if (fileObject != null) {
                String line;
                ArrayList<String> lines = new ArrayList<String>();
                Reader reader = fileObject.openReader(true);
                LineNumberReader lineReader = new LineNumberReader(reader);
                while ((line = lineReader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    lines.add(line);
                }
                return lines;
            }
        }
        catch (FileNotFoundException | NoSuchFileException fileObject) {
        }
        catch (FilerException e) {
            this.ctx.logDebug("FilerException reading services file", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.ctx.logWarn("Error reading services file: " + e.getMessage(), new Object[0]);
        }
        return Collections.emptyList();
    }
}

