/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.Json;
import io.avaje.jsonb.generator.NamingConvention;
import io.avaje.jsonb.generator.Util;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

class NamingConventionReader {
    private static final String JSON_ANNOTATION = "io.avaje.jsonb.Json";
    private static final String NAMING_ATTRIBUTE = "naming()";
    private static final String TYPEPROPERTY_ATTRIBUTE = "typeProperty()";
    private static final String CASEINSENSITIVEKEYS_ATTRIBUTE = "caseInsensitiveKeys()";
    private String typeProperty;
    private boolean caseInsensitiveKeys;
    private NamingConvention namingConvention;

    NamingConventionReader(TypeElement element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!JSON_ANNOTATION.equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                String key = entry.getKey().toString();
                if (key.equals(NAMING_ATTRIBUTE)) {
                    this.namingConvention = NamingConvention.of(NamingConventionReader.naming(entry.getValue().toString()));
                    continue;
                }
                if (key.equals(TYPEPROPERTY_ATTRIBUTE)) {
                    this.typeProperty = Util.trimQuotes(entry.getValue().toString());
                    continue;
                }
                if (!key.equals(CASEINSENSITIVEKEYS_ATTRIBUTE)) continue;
                this.caseInsensitiveKeys = Boolean.parseBoolean(entry.getValue().toString());
            }
        }
    }

    static Json.Naming naming(String entry) {
        int pos = entry.lastIndexOf(46);
        if (pos > -1) {
            entry = entry.substring(pos + 1);
        }
        return Json.Naming.valueOf((String)entry);
    }

    NamingConvention get() {
        return this.namingConvention != null ? this.namingConvention : NamingConvention.of(Json.Naming.Match);
    }

    String typeProperty() {
        return this.typeProperty != null ? this.typeProperty : "@type";
    }

    boolean isCaseInsensitiveKeys() {
        return this.caseInsensitiveKeys;
    }
}

