/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.Json;
import io.avaje.jsonb.generator.FieldReader;
import io.avaje.jsonb.generator.GenericType;
import io.avaje.jsonb.generator.MethodReader;
import io.avaje.jsonb.generator.NamingConvention;
import io.avaje.jsonb.generator.ProcessingContext;
import io.avaje.jsonb.generator.TypeSubTypeMeta;
import io.avaje.jsonb.generator.TypeSubTypeReader;
import io.avaje.jsonb.generator.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

class TypeReader {
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private final List<MethodReader> publicConstructors = new ArrayList<MethodReader>();
    private final List<FieldReader> allFields = new ArrayList<FieldReader>();
    private final Map<String, FieldReader> allFieldMap = new HashMap<String, FieldReader>();
    private final Map<String, MethodReader> maybeSetterMethods = new LinkedHashMap<String, MethodReader>();
    private final Map<String, MethodReader> maybeGetterMethods = new LinkedHashMap<String, MethodReader>();
    private final Map<String, MethodReader> allGetterMethods = new LinkedHashMap<String, MethodReader>();
    private final Map<String, MethodReader> allSetterMethods = new LinkedHashMap<String, MethodReader>();
    private final TypeSubTypeReader subTypes;
    private final TypeElement baseType;
    private final List<String> genericTypeParams;
    private final ProcessingContext context;
    private final NamingConvention namingConvention;
    private final boolean hasJsonAnnotation;
    private MethodReader constructor;
    private boolean defaultPublicConstructor;
    private final Map<String, MethodReader.MethodParam> constructorParamMap = new LinkedHashMap<String, MethodReader.MethodParam>();
    private TypeSubTypeMeta currentSubType;
    private boolean nonAccessibleField;
    private final Map<String, Element> mixInFields;

    TypeReader(TypeElement baseType, ProcessingContext context, NamingConvention namingConvention) {
        this.baseType = baseType;
        this.genericTypeParams = this.initTypeParams(baseType);
        this.context = context;
        this.mixInFields = new HashMap<String, Element>();
        this.namingConvention = namingConvention;
        this.hasJsonAnnotation = baseType.getAnnotation(Json.class) != null;
        this.subTypes = new TypeSubTypeReader(baseType, context);
    }

    public TypeReader(TypeElement baseType, TypeElement mixInType, ProcessingContext context, NamingConvention namingConvention) {
        this.baseType = baseType;
        this.genericTypeParams = this.initTypeParams(baseType);
        this.mixInFields = mixInType.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.FIELD).collect(Collectors.toMap(e -> e.getSimpleName().toString(), e -> e));
        this.context = context;
        this.namingConvention = namingConvention;
        this.hasJsonAnnotation = baseType.getAnnotation(Json.class) != null;
        this.subTypes = new TypeSubTypeReader(baseType, context);
    }

    private List<String> initTypeParams(TypeElement beanType) {
        if (beanType.getTypeParameters().isEmpty()) {
            return Collections.emptyList();
        }
        return beanType.getTypeParameters().stream().map(Object::toString).collect(Collectors.toList());
    }

    int genericTypeParamsCount() {
        return this.genericTypeParams.size();
    }

    void read(TypeElement type) {
        ArrayList<FieldReader> localFields = new ArrayList<FieldReader>();
        for (Element element : type.getEnclosedElements()) {
            switch (element.getKind()) {
                case CONSTRUCTOR: {
                    this.readConstructor(element, type);
                    break;
                }
                case FIELD: {
                    this.readField(element, localFields);
                    break;
                }
                case METHOD: {
                    this.readMethod(element, type);
                }
            }
        }
        if (this.currentSubType == null && type != this.baseType) {
            this.allFields.addAll(0, localFields);
            for (FieldReader fieldReader : localFields) {
                this.allFieldMap.put(fieldReader.fieldName(), fieldReader);
            }
        } else {
            for (FieldReader fieldReader : localFields) {
                FieldReader commonField = this.allFieldMap.get(fieldReader.fieldName());
                if (commonField == null) {
                    this.allFields.add(fieldReader);
                    this.allFieldMap.put(fieldReader.fieldName(), fieldReader);
                    continue;
                }
                commonField.addSubType(this.currentSubType);
            }
        }
    }

    private void readField(Element element, List<FieldReader> localFields) {
        Element mixInField = this.mixInFields.get(element.getSimpleName().toString());
        if (mixInField != null && mixInField.asType().equals(element.asType())) {
            element = mixInField;
        }
        if (this.includeField(element)) {
            localFields.add(new FieldReader(element, this.namingConvention, this.currentSubType, this.genericTypeParams));
        }
    }

    private boolean includeField(Element element) {
        return !element.getModifiers().contains((Object)Modifier.TRANSIENT) && !element.getModifiers().contains((Object)Modifier.STATIC);
    }

    private void readConstructor(Element element, TypeElement type) {
        if (this.currentSubType != null ? this.currentSubType.element() != type : type != this.baseType) {
            return;
        }
        ExecutableElement ex = (ExecutableElement)element;
        MethodReader methodReader = new MethodReader(this.context, ex, this.baseType).read();
        if (methodReader.isPublic()) {
            if (this.currentSubType != null) {
                this.currentSubType.addConstructor(methodReader);
            } else {
                if (methodReader.getParams().isEmpty()) {
                    this.defaultPublicConstructor = true;
                }
                this.publicConstructors.add(methodReader);
            }
        }
    }

    private void readMethod(Element element, TypeElement type) {
        ExecutableElement methodElement = (ExecutableElement)element;
        if (methodElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            List<? extends VariableElement> parameters = methodElement.getParameters();
            String methodKey = methodElement.getSimpleName().toString();
            MethodReader methodReader = new MethodReader(this.context, methodElement, type).read();
            if (parameters.size() == 1) {
                if (!this.maybeSetterMethods.containsKey(methodKey)) {
                    this.maybeSetterMethods.put(methodKey, methodReader);
                }
                this.allSetterMethods.put(methodKey.toLowerCase(), methodReader);
            } else if (parameters.size() == 0) {
                if (!this.maybeGetterMethods.containsKey(methodKey)) {
                    this.maybeGetterMethods.put(methodKey, methodReader);
                }
                this.allGetterMethods.put(methodKey.toLowerCase(), methodReader);
            }
        }
    }

    private void matchFieldsToSetterOrConstructor() {
        for (FieldReader field : this.allFields) {
            if (!field.includeFromJson()) continue;
            if (this.constructorParamMap.get(field.fieldName()) != null) {
                field.constructorParam();
                continue;
            }
            this.matchFieldToSetter(field);
        }
    }

    private void matchFieldToSetter(FieldReader field) {
        if (!(this.matchFieldToSetter2(field, false) || this.matchFieldToSetter2(field, true) || this.matchFieldToSetterByParam(field) || field.isPublicField())) {
            this.context.logError("Non public field " + this.baseType + " " + field.fieldName() + " with no matching setter or constructor?", new Object[0]);
        }
    }

    private boolean matchFieldToSetterByParam(FieldReader field) {
        String fieldName = field.fieldName();
        for (MethodReader methodReader : this.maybeSetterMethods.values()) {
            List<MethodReader.MethodParam> params = methodReader.getParams();
            MethodReader.MethodParam methodParam = params.get(0);
            if (!methodParam.name().equals(fieldName)) continue;
            field.setterMethod(methodReader);
            return true;
        }
        return false;
    }

    private boolean matchFieldToSetter2(FieldReader field, boolean loose) {
        String name = field.fieldName();
        MethodReader setter = this.setterLookup(name, loose);
        if (setter != null) {
            field.setterMethod(setter);
            return true;
        }
        setter = this.setterLookup(this.setterName(name), loose);
        if (setter != null) {
            field.setterMethod(setter);
            return true;
        }
        if (field.typeBooleanWithIsPrefix() && (setter = this.setterLookup(this.setterName(name.substring(2)), loose)) != null) {
            field.setterMethod(setter);
            return true;
        }
        return false;
    }

    private MethodReader setterLookup(String name, boolean loose) {
        if (loose) {
            return this.allSetterMethods.get(name.toLowerCase());
        }
        return this.maybeSetterMethods.get(name);
    }

    private void matchFieldsToGetter() {
        for (FieldReader field : this.allFields) {
            if (!field.includeToJson()) continue;
            this.matchFieldToGetter(field);
        }
    }

    private void matchFieldToGetter(FieldReader field) {
        if (!(this.matchFieldToGetter2(field, false) || this.matchFieldToGetter2(field, true) || field.isPublicField())) {
            this.nonAccessibleField = true;
            if (this.hasJsonAnnotation) {
                this.context.logError("Non accessible field " + this.baseType + " " + field.fieldName() + " with no matching getter?", new Object[0]);
            } else {
                this.context.logDebug("Non accessible field " + this.baseType + " " + field.fieldName(), new Object[0]);
            }
        }
    }

    private boolean matchFieldToGetter2(FieldReader field, boolean loose) {
        String name = field.fieldName();
        MethodReader getter = this.getterLookup(name, loose);
        if (getter != null) {
            field.getterMethod(getter);
            return true;
        }
        getter = this.getterLookup(this.getterName(name), loose);
        if (getter != null) {
            field.getterMethod(getter);
            return true;
        }
        getter = this.getterLookup(this.isGetterName(name), loose);
        if (getter != null) {
            field.getterMethod(getter);
            return true;
        }
        if (field.typeObjectBooleanWithIsPrefix() && (getter = this.getterLookup(this.getterName(name.substring(2)), loose)) != null) {
            field.getterMethod(getter);
            return true;
        }
        return false;
    }

    private MethodReader getterLookup(String name, boolean loose) {
        if (!loose) {
            return this.maybeGetterMethods.get(name);
        }
        return this.allGetterMethods.get(name.toLowerCase());
    }

    private String setterName(String name) {
        return "set" + Util.initCap(name);
    }

    private String getterName(String name) {
        return "get" + Util.initCap(name);
    }

    private String isGetterName(String name) {
        return "is" + Util.initCap(name);
    }

    boolean nonAccessibleField() {
        return this.nonAccessibleField;
    }

    List<FieldReader> allFields() {
        return this.allFields;
    }

    MethodReader constructor() {
        return this.constructor;
    }

    private MethodReader determineConstructor() {
        if (this.defaultPublicConstructor) {
            return null;
        }
        if (this.publicConstructors.size() == 1) {
            return this.publicConstructors.get(0);
        }
        ArrayList<MethodReader> allPublic = new ArrayList<MethodReader>();
        for (MethodReader ctor : this.publicConstructors) {
            if (!ctor.isPublic()) continue;
            allPublic.add(ctor);
        }
        if (allPublic.size() == 1) {
            return (MethodReader)allPublic.get(0);
        }
        int argCount = 0;
        MethodReader largestConstructor = null;
        for (MethodReader ctor : this.publicConstructors) {
            int paramCount;
            if (!ctor.isPublic() || (paramCount = ctor.getParams().size()) <= argCount) continue;
            largestConstructor = ctor;
            argCount = paramCount;
        }
        return largestConstructor;
    }

    void process() {
        TypeElement superElement;
        String base = this.baseType.getQualifiedName().toString();
        if (!GenericType.isGeneric(base)) {
            this.read(this.baseType);
        }
        if ((superElement = this.superOf(this.baseType)) != null) {
            this.addSuperType(superElement, null);
        }
        this.readSubTypes();
        this.processCompleted();
    }

    private void readSubTypes() {
        if (this.hasSubTypes()) {
            Iterator<TypeSubTypeMeta> iterator = this.subTypes.subTypes().iterator();
            while (iterator.hasNext()) {
                TypeSubTypeMeta subType;
                this.currentSubType = subType = iterator.next();
                TypeElement element = this.context.element(subType.type());
                this.currentSubType.setElement(element);
                this.addSuperType(element, this.baseType);
            }
        }
    }

    List<TypeSubTypeMeta> subTypes() {
        return this.subTypes.subTypes();
    }

    void processCompleted() {
        this.setFieldPositions();
        this.constructor = this.determineConstructor();
        if (this.constructor != null) {
            List<MethodReader.MethodParam> params = this.constructor.getParams();
            for (MethodReader.MethodParam param : params) {
                this.constructorParamMap.put(param.name(), param);
            }
        }
        this.matchFieldsToSetterOrConstructor();
        this.matchFieldsToGetter();
    }

    private void setFieldPositions() {
        int offset = this.subTypes.hasSubTypes() ? 1 : 0;
        int size = this.allFields.size();
        for (int pos = 0; pos < size; ++pos) {
            this.allFields.get(pos).position(pos + offset);
        }
    }

    private void addSuperType(TypeElement element, TypeElement matchType) {
        String type = element.getQualifiedName().toString();
        if (!type.equals(JAVA_LANG_OBJECT) && !GenericType.isGeneric(type)) {
            this.read(element);
            this.addSuperType(this.superOf(element), matchType);
        }
    }

    private TypeElement superOf(TypeElement element) {
        return (TypeElement)this.context.asElement(element.getSuperclass());
    }

    boolean hasSubTypes() {
        return this.subTypes.hasSubTypes();
    }
}

