/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.ProcessingContext;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

final class MethodReader {
    private final ExecutableElement element;
    private final String methodName;
    private final List<MethodParam> params = new ArrayList<MethodParam>();

    MethodReader(ProcessingContext context, ExecutableElement element, TypeElement beanType) {
        this.element = element;
        this.methodName = element.getSimpleName().toString();
    }

    public String toString() {
        return this.methodName;
    }

    MethodReader read() {
        List<? extends VariableElement> ps = this.element.getParameters();
        for (VariableElement variableElement : ps) {
            this.params.add(new MethodParam(variableElement));
        }
        return this;
    }

    String getName() {
        return this.methodName;
    }

    List<MethodParam> getParams() {
        return this.params;
    }

    public boolean isPublic() {
        return this.element.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    static class MethodParam {
        private final String simpleName;

        MethodParam(VariableElement param) {
            this.simpleName = param.getSimpleName().toString();
        }

        String name() {
            return this.simpleName;
        }
    }
}

