/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.Naming;

final class NamingConvention {
    private final Naming naming;
    private final Convert convert;

    static NamingConvention of(Naming naming) {
        return new NamingConvention(naming);
    }

    private NamingConvention(Naming naming) {
        this.naming = naming;
        this.convert = this.init(naming);
    }

    public String toString() {
        return this.naming.toString();
    }

    Convert init(Naming naming) {
        switch (naming) {
            case Match: {
                return fieldName -> fieldName;
            }
            case LowerHyphen: {
                return new LowerExtra('-');
            }
            case LowerUnderscore: {
                return new LowerExtra('_');
            }
            case LowerSpace: {
                return new LowerExtra(' ');
            }
            case UpperCamel: {
                return new UpperCamel();
            }
            case UpperUnderscore: {
                return new UpperExtra('_');
            }
            case UpperHyphen: {
                return new UpperExtra('-');
            }
            case UpperSpace: {
                return new UpperExtra(' ');
            }
        }
        throw new IllegalStateException();
    }

    public String from(String fieldName) {
        return this.convert.convert(fieldName);
    }

    static interface Convert {
        public String convert(String var1);
    }

    static class LowerExtra
    implements Convert {
        private final char extra;

        LowerExtra(char extra) {
            this.extra = extra;
        }

        @Override
        public String convert(String name) {
            StringBuilder sb = new StringBuilder(name.length());
            boolean upper = false;
            for (char ch : name.toCharArray()) {
                if (Character.isUpperCase(ch)) {
                    if (!upper) {
                        sb.append(this.extra);
                    }
                    sb.append(Character.toLowerCase(ch));
                    upper = true;
                    continue;
                }
                sb.append(ch);
                upper = false;
            }
            return sb.toString();
        }
    }

    static class UpperCamel
    implements Convert {
        UpperCamel() {
        }

        @Override
        public String convert(String name) {
            if (name.toLowerCase().equals(name)) {
                return name.toUpperCase();
            }
            StringBuilder sb = new StringBuilder(name.length());
            boolean change = true;
            for (char ch : name.toCharArray()) {
                if (change && Character.isLowerCase(ch)) {
                    sb.append(Character.toUpperCase(ch));
                    change = false;
                    continue;
                }
                sb.append(ch);
            }
            return sb.toString();
        }
    }

    static class UpperExtra
    implements Convert {
        private final char extra;

        UpperExtra(char extra) {
            this.extra = extra;
        }

        @Override
        public String convert(String name) {
            StringBuilder sb = new StringBuilder(name.length());
            boolean upper = false;
            for (char ch : name.toCharArray()) {
                if (Character.isUpperCase(ch)) {
                    if (!upper) {
                        sb.append(this.extra);
                    }
                    sb.append(ch);
                    upper = true;
                    continue;
                }
                sb.append(Character.toUpperCase(ch));
                upper = false;
            }
            return sb.toString();
        }
    }
}

