/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.AdapterName;
import io.avaje.jsonb.generator.BeanReader;
import io.avaje.jsonb.generator.ComponentMetaData;
import io.avaje.jsonb.generator.ComponentReader;
import io.avaje.jsonb.generator.ImportPrism;
import io.avaje.jsonb.generator.MixInPrism;
import io.avaje.jsonb.generator.ProcessingContext;
import io.avaje.jsonb.generator.SimpleAdapterWriter;
import io.avaje.jsonb.generator.SimpleComponentWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

@SupportedAnnotationTypes(value={"io.avaje.jsonb.Json", "io.avaje.jsonb.Json.Import", "io.avaje.jsonb.Json.MixIn"})
public final class Processor
extends AbstractProcessor {
    private final ComponentMetaData metaData = new ComponentMetaData();
    private final List<BeanReader> allReaders = new ArrayList<BeanReader>();
    private final Set<String> sourceTypes = new HashSet<String>();
    private final Set<String> mixInImports = new HashSet<String>();
    private ProcessingContext context;
    private SimpleComponentWriter componentWriter;
    private boolean readModuleInfo;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.context = new ProcessingContext(processingEnv);
        this.componentWriter = new SimpleComponentWriter(this.context, this.metaData);
    }

    private void readModule() {
        if (this.readModuleInfo) {
            return;
        }
        this.readModuleInfo = true;
        new ComponentReader(this.context, this.metaData).read();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment round) {
        this.readModule();
        this.writeAdapters(round.getElementsAnnotatedWith(this.context.element("io.avaje.jsonb.Json")));
        this.writeAdaptersForMixInTypes(round.getElementsAnnotatedWith(this.context.element("io.avaje.jsonb.Json.MixIn")));
        this.writeAdaptersForImported(round.getElementsAnnotatedWith(this.context.element("io.avaje.jsonb.Json.Import")));
        this.initialiseComponent();
        this.cascadeTypes();
        this.writeComponent(round.processingOver());
        return false;
    }

    private void cascadeTypes() {
        while (!this.allReaders.isEmpty()) {
            this.cascadeTypesInner();
        }
    }

    private void cascadeTypesInner() {
        ArrayList<BeanReader> copy = new ArrayList<BeanReader>(this.allReaders);
        this.allReaders.clear();
        TreeSet<String> extraTypes = new TreeSet<String>();
        for (BeanReader reader : copy) {
            reader.cascadeTypes(extraTypes);
        }
        for (String type : extraTypes) {
            TypeElement element;
            if (this.ignoreType(type) || !this.cascadeElement(element = this.context.element(type))) continue;
            this.writeAdapterForType(element);
        }
    }

    private boolean cascadeElement(TypeElement element) {
        return element.getKind() != ElementKind.ENUM && !this.metaData.contains(this.adapterName(element));
    }

    private String adapterName(TypeElement element) {
        return new AdapterName(element).fullName();
    }

    private boolean ignoreType(String type) {
        return type.indexOf(46) == -1 || type.startsWith("java.") || type.startsWith("javax.") || this.sourceTypes.contains(type);
    }

    private void writeAdaptersForMixInTypes(Set<? extends Element> mixInElements) {
        for (Element element : mixInElements) {
            TypeMirror mirror = MixInPrism.getInstanceOn(element).value();
            String importType = mirror.toString();
            TypeElement element2 = (TypeElement)this.context.asElement(mirror);
            this.mixInImports.add(importType);
            this.writeAdapterForMixInType(element2, this.context.element(element.asType().toString()));
        }
    }

    private void writeAdaptersForImported(Set<? extends Element> importedElements) {
        for (Element element : importedElements) {
            for (TypeMirror importType : ImportPrism.getInstanceOn(element).value()) {
                if (this.mixInImports.contains(importType.toString())) continue;
                this.writeAdapterForType((TypeElement)this.context.asElement(importType));
            }
        }
    }

    private void initialiseComponent() {
        this.metaData.initialiseFullName();
        try {
            this.componentWriter.initialise();
        }
        catch (IOException e) {
            this.context.logError("Error creating writer for JsonbComponent", e);
        }
    }

    private void writeComponent(boolean processingOver) {
        if (processingOver) {
            try {
                this.componentWriter.write();
                this.componentWriter.writeMetaInf();
            }
            catch (IOException e) {
                this.context.logError("Error writing component", e);
            }
        }
    }

    private void writeAdapters(Set<? extends Element> beans) {
        for (Element element : beans) {
            if (!(element instanceof TypeElement)) {
                this.context.logError("unexpected type [" + String.valueOf(element) + "]", new Object[0]);
                continue;
            }
            this.writeAdapterForType((TypeElement)element);
        }
    }

    private void writeAdapterForType(TypeElement typeElement) {
        BeanReader beanReader = new BeanReader(typeElement, this.context);
        this.writeAdapter(typeElement, beanReader);
    }

    private void writeAdapterForMixInType(TypeElement typeElement, TypeElement mixin) {
        BeanReader beanReader = new BeanReader(typeElement, mixin, this.context);
        this.writeAdapter(typeElement, beanReader);
    }

    private void writeAdapter(TypeElement typeElement, BeanReader beanReader) {
        beanReader.read();
        if (beanReader.nonAccessibleField()) {
            if (beanReader.hasJsonAnnotation()) {
                this.context.logError("Error JsonAdapter due to nonAccessibleField for %s ", beanReader);
            }
            return;
        }
        try {
            SimpleAdapterWriter beanWriter = new SimpleAdapterWriter(beanReader, this.context);
            this.metaData.add(beanWriter.fullName());
            if (beanWriter.hasGenericFactory()) {
                this.metaData.addFactory(beanWriter.fullName());
            }
            beanWriter.write();
            this.allReaders.add(beanReader);
            this.sourceTypes.add(typeElement.getSimpleName().toString());
        }
        catch (IOException e) {
            this.context.logError("Error writing JsonAdapter for %s %s", beanReader, e);
        }
    }
}

