/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.IgnorePrism;
import io.avaje.jsonb.generator.RawPrism;
import io.avaje.jsonb.generator.UnmappedPrism;
import javax.lang.model.element.Element;

final class PropertyIgnoreReader {
    private final boolean unmapped;
    private final boolean raw;
    private boolean ignoreSerialize;
    private boolean ignoreDeserialize;

    PropertyIgnoreReader(Element element) {
        this.unmapped = UnmappedPrism.getInstanceOn(element) != null;
        this.raw = RawPrism.getInstanceOn(element) != null;
        IgnorePrism ignored = IgnorePrism.getInstanceOn(element);
        if (ignored != null) {
            this.ignoreDeserialize = ignored.deserialize() == false;
            this.ignoreSerialize = ignored.serialize() == false;
        }
    }

    boolean unmapped() {
        return this.unmapped;
    }

    boolean raw() {
        return this.raw;
    }

    boolean serialize() {
        return !this.ignoreSerialize;
    }

    boolean deserialize() {
        return !this.ignoreDeserialize;
    }
}

