/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

class RawPrism {
    public static final String PRISM_TYPE = "io.avaje.jsonb.Json.Raw";
    final Values values;
    final boolean isValid;
    final AnnotationMirror mirror;
    private Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private boolean valid = true;

    static RawPrism getInstanceOn(Element e) {
        AnnotationMirror m = RawPrism.getMirror(PRISM_TYPE, e);
        if (m == null) {
            return null;
        }
        return RawPrism.getInstance(m);
    }

    static List<RawPrism> getAllInstancesOn(Element e) {
        return RawPrism.getMirrors(PRISM_TYPE, e).stream().map(RawPrism::getInstance).collect(Collectors.toList());
    }

    static Optional<RawPrism> getOptionalOn(Element e) {
        AnnotationMirror m = RawPrism.getMirror(PRISM_TYPE, e);
        if (m == null) {
            return Optional.empty();
        }
        return RawPrism.getOptional(m);
    }

    static RawPrism getInstance(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return null;
        }
        return new RawPrism(mirror);
    }

    static Optional<RawPrism> getOptional(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return Optional.empty();
        }
        return Optional.of(new RawPrism(mirror));
    }

    private RawPrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    private <T> T getValue(String name, Class<T> clazz) {
        T result = RawPrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private <T> List<T> getArrayValues(String name, Class<T> clazz) {
        List<T> result = RawPrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private static AnnotationMirror getMirror(String fqn, Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!fqn.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static List<AnnotationMirror> getMirrors(String fqn, Element target) {
        ArrayList<AnnotationMirror> mirrors = new ArrayList<AnnotationMirror>();
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!fqn.contentEquals(mfqn)) continue;
            mirrors.add(annotationMirror);
        }
        return mirrors;
    }

    private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    private static <T> List<T> getArrayValues(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return List.of();
        }
        if (av.getValue() instanceof List) {
            ArrayList<T> result = new ArrayList<T>();
            for (AnnotationValue v : RawPrism.getValueAsList(av)) {
                if (clazz.isInstance(v.getValue())) {
                    result.add(clazz.cast(v.getValue()));
                    continue;
                }
                return List.of();
            }
            return result;
        }
        return List.of();
    }

    private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
        return (List)av.getValue();
    }

    static class Values {
        private Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }
    }
}

