/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

final class Util {
    Util() {
    }

    static boolean validImportType(String type) {
        return type.indexOf(46) > 0;
    }

    static String packageOf(String cls) {
        int pos = cls.lastIndexOf(46);
        return pos == -1 ? "" : cls.substring(0, pos);
    }

    static String shortName(String fullType) {
        int p = fullType.lastIndexOf(46);
        if (p == -1) {
            return fullType;
        }
        return fullType.substring(p + 1);
    }

    static String commonParent(String currentTop, String aPackage) {
        int next;
        if (aPackage == null) {
            return currentTop;
        }
        if (currentTop == null) {
            return Util.packageOf(aPackage);
        }
        if (aPackage.startsWith(currentTop)) {
            return currentTop;
        }
        do {
            if ((next = currentTop.lastIndexOf(46)) <= -1 || !aPackage.startsWith(currentTop = currentTop.substring(0, next))) continue;
            return currentTop;
        } while (next > -1);
        return currentTop;
    }

    static String initCap(String input) {
        if (input.length() < 2) {
            return input.toUpperCase();
        }
        return Character.toUpperCase(input.charAt(0)) + input.substring(1);
    }

    static String escapeQuotes(String input) {
        return input.replaceAll("^\"|\"$", "\\\\\"");
    }

    static String trimClassSuffix(String nameWithSuffix) {
        return nameWithSuffix.substring(0, nameWithSuffix.length() - 6);
    }

    static String initLower(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        boolean toLower = true;
        for (char ch : name.toCharArray()) {
            if (Character.isUpperCase(ch)) {
                if (toLower) {
                    sb.append(Character.toLowerCase(ch));
                    continue;
                }
                sb.append(ch);
                continue;
            }
            sb.append(ch);
            toLower = false;
        }
        return sb.toString();
    }

    static String baseTypeOfAdapter(String adapterFullName) {
        int posLast = adapterFullName.lastIndexOf(46);
        int posPrior = adapterFullName.lastIndexOf(46, posLast - 1);
        int nameEnd = adapterFullName.length() - 11;
        if (posPrior == -1) {
            return adapterFullName.substring(posLast + 1, nameEnd);
        }
        String className = adapterFullName.substring(0, posPrior) + adapterFullName.substring(posLast, nameEnd);
        int $index = className.indexOf("$");
        if ($index != -1) {
            return className.substring(0, $index);
        }
        return className;
    }
}

