/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.Append;
import io.avaje.jsonb.generator.ComponentMetaData;
import io.avaje.jsonb.generator.ProcessingContext;
import io.avaje.jsonb.generator.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;

final class SimpleComponentWriter {
    private final ComponentMetaData metaData;
    private final Set<String> importTypes = new TreeSet<String>();
    private Append writer;
    private JavaFileObject fileObject;

    SimpleComponentWriter(ComponentMetaData metaData) {
        this.metaData = metaData;
    }

    void initialise() throws IOException {
        if (this.fileObject == null) {
            this.fileObject = ProcessingContext.createWriter(this.metaData.fullName());
        }
    }

    private Writer createFileWriter() throws IOException {
        return this.fileObject.openWriter();
    }

    void write() throws IOException {
        this.writer = new Append(this.createFileWriter());
        this.writePackage();
        this.writeImports();
        this.writeClassStart();
        this.writeRegister();
        this.writeClassEnd();
        this.writer.close();
    }

    void writeMetaInf() throws IOException {
        FileObject fileObject = ProcessingContext.createMetaInfWriterFor("META-INF/services/io.avaje.jsonb.Jsonb$GeneratedComponent");
        if (fileObject != null) {
            Writer writer = fileObject.openWriter();
            writer.write(this.metaData.fullName());
            writer.close();
        }
    }

    private void writeRegister() {
        String adapterShortName;
        this.writer.append("  @Override").eol();
        this.writer.append("  public void register(Jsonb.Builder builder) {").eol();
        List<String> strings = this.metaData.allFactories();
        for (String adapterFullName : strings) {
            adapterShortName = Util.shortName(adapterFullName);
            this.writer.append("    builder.add(%s.Factory);", adapterShortName).eol();
        }
        for (String adapterFullName : this.metaData.all()) {
            adapterShortName = Util.shortName(adapterFullName);
            String typeName = this.typeShortName(adapterShortName);
            this.writer.append("    builder.add(%s.class, %s::new);", typeName, adapterShortName).eol();
        }
        this.writer.append("  }").eol().eol();
    }

    private String typeShortName(String adapterShortName) {
        String typeName = adapterShortName.substring(0, adapterShortName.length() - 11);
        return typeName.replace("$", ".");
    }

    private void writeClassEnd() {
        this.writer.append("}").eol();
    }

    private void writeClassStart() {
        String fullName = this.metaData.fullName();
        String shortName = Util.shortName(fullName);
        this.writer.append("@Generated").eol();
        List<String> factories = this.metaData.allFactories();
        if (!factories.isEmpty()) {
            this.writer.append("@MetaData.Factory({");
            this.writeMetaDataEntry(factories);
            this.writer.append("})").eol();
        }
        this.writer.append("@MetaData({");
        List<String> all = this.metaData.all();
        this.writeMetaDataEntry(all);
        this.writer.append("})").eol();
        this.writer.append("public class %s implements Jsonb.GeneratedComponent {", shortName).eol().eol();
    }

    private void writeMetaDataEntry(List<String> entries) {
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                this.writer.append(", ");
            }
            this.writer.append("%s.class", Util.shortName(entries.get(i)));
        }
    }

    private void writeImports() {
        this.importTypes.add("io.avaje.jsonb.Jsonb");
        this.importTypes.add("io.avaje.jsonb.spi.*");
        this.importTypes.addAll(this.metaData.allImports());
        for (String importType : this.importTypes) {
            if (!Util.validImportType(importType)) continue;
            this.writer.append("import %s;", importType).eol();
        }
        this.writer.eol();
    }

    private void writePackage() {
        String packageName = this.metaData.packageName();
        if (packageName != null && !packageName.isEmpty()) {
            this.writer.append("package %s;", packageName).eol().eol();
        }
    }
}

