/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.SubTypePrism;
import io.avaje.jsonb.generator.SubTypesPrism;
import io.avaje.jsonb.generator.TypeSubTypeMeta;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;

final class TypeSubTypeReader {
    private final TypeElement baseType;
    private final List<TypeSubTypeMeta> subTypes = new ArrayList<TypeSubTypeMeta>();

    TypeSubTypeReader(TypeElement baseType) {
        this.baseType = baseType;
        this.read();
    }

    List<TypeSubTypeMeta> subTypes() {
        return this.subTypes;
    }

    boolean hasSubTypes() {
        return !this.subTypes.isEmpty();
    }

    void read() {
        for (AnnotationMirror annotationMirror : this.baseType.getAnnotationMirrors()) {
            SubTypePrism subtypePrism = SubTypePrism.getInstance(annotationMirror);
            SubTypesPrism subtypesPrism = SubTypesPrism.getInstance(annotationMirror);
            if (subtypePrism != null) {
                this.subTypes.add(new TypeSubTypeMeta(subtypePrism));
                continue;
            }
            if (subtypesPrism == null) continue;
            subtypesPrism.value().stream().map(TypeSubTypeMeta::new).forEach(this.subTypes::add);
        }
    }
}

