/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

class ValuePrism {
    public static final String PRISM_TYPE = "io.avaje.jsonb.Json.Value";
    final Values values;
    final boolean isValid;
    final AnnotationMirror mirror;
    private Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private boolean valid = true;

    static boolean isPresent(Element element) {
        return ValuePrism.getInstanceOn(element) != null;
    }

    static ValuePrism getInstanceOn(Element element) {
        AnnotationMirror mirror = ValuePrism.getMirror(element);
        if (mirror == null) {
            return null;
        }
        return ValuePrism.getInstance(mirror);
    }

    static Optional<ValuePrism> getOptionalOn(Element element) {
        AnnotationMirror mirror = ValuePrism.getMirror(element);
        if (mirror == null) {
            return Optional.empty();
        }
        return ValuePrism.getOptional(mirror);
    }

    static ValuePrism getInstance(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return null;
        }
        return new ValuePrism(mirror);
    }

    static Optional<ValuePrism> getOptional(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return Optional.empty();
        }
        return Optional.of(new ValuePrism(mirror));
    }

    private ValuePrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    private static AnnotationMirror getMirror(Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!PRISM_TYPE.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    static class Values {
        private Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }
    }
}

