/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.Append;
import io.avaje.jsonb.generator.ClassReader;
import io.avaje.jsonb.generator.FieldReader;
import io.avaje.jsonb.generator.MethodReader;
import io.avaje.jsonb.generator.ProcessingContext;
import io.avaje.jsonb.generator.SubTypePrism;
import io.avaje.jsonb.generator.Util;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.TypeElement;

final class TypeSubTypeMeta {
    private final String type;
    private String name;
    private final String shortType;
    private TypeElement typeElement;
    private boolean defaultPublicConstructor;
    private final List<MethodReader> publicConstructors = new ArrayList<MethodReader>();
    private final Set<String> constructorFieldNames = new LinkedHashSet<String>();

    public String toString() {
        return this.type;
    }

    TypeSubTypeMeta(SubTypePrism prism) {
        this.type = prism.type().toString();
        this.name = Util.escapeQuotes(prism.name());
        this.shortType = Util.shortType(this.type);
    }

    void setElement(TypeElement element) {
        this.typeElement = element;
    }

    TypeElement element() {
        return this.typeElement;
    }

    String type() {
        return this.type;
    }

    String name() {
        if (this.name.isBlank()) {
            this.name = Util.shortType(this.type);
        }
        return this.name;
    }

    void addConstructor(MethodReader methodReader) {
        if (methodReader.getParams().isEmpty()) {
            this.defaultPublicConstructor = true;
        }
        this.publicConstructors.add(methodReader);
    }

    void writeFromJsonBuild(Append writer, String typeVar, String varName, ClassReader beanReader, boolean useSwitch, boolean useEnum) {
        if (useSwitch) {
            if (useEnum) {
                writer.append("      case %s", this.name()).appendSwitchCase().eol();
            } else {
                writer.append("      case \"%s\"", this.name()).appendSwitchCase().eol();
            }
            writer.append("  ");
            this.writeFromJsonConstructor(writer, varName, beanReader);
            this.writeFromJsonSetters(writer, varName, beanReader, useSwitch);
            if (ProcessingContext.useEnhancedSwitch()) {
                writer.append("        yield _$%s;", varName).eol();
                writer.append("      }").eol();
            } else {
                writer.append("        return _$%s;", varName).eol();
            }
        } else {
            if (useEnum) {
                writer.append("    if (%s.equals(%s)) {", this.name(), typeVar).eol();
            } else {
                writer.append("    if (\"%s\".equals(%s)) {", this.name(), typeVar).eol();
            }
            this.writeFromJsonConstructor(writer, varName, beanReader);
            this.writeFromJsonSetters(writer, varName, beanReader, useSwitch);
            writer.append("      return _$%s;", varName).eol();
            writer.append("    }").eol();
        }
    }

    private void writeFromJsonSetters(Append writer, String varName, ClassReader beanReader, boolean useSwitch) {
        for (FieldReader field : beanReader.allFields()) {
            if (!this.isIncludeSetter(field)) continue;
            if (useSwitch) {
                writer.append("  ");
            }
            field.writeFromJsonSetter(writer, varName, "  ");
        }
    }

    private boolean isIncludeSetter(FieldReader field) {
        return field.includeFromJson() && !this.constructorFieldNames.contains(field.fieldName()) && field.includeForType(this);
    }

    private void writeFromJsonConstructor(Append writer, String varName, ClassReader beanReader) {
        writer.append("      %s _$%s = new %s(", this.shortType, varName, this.shortType);
        MethodReader constructor = this.findConstructor();
        if (constructor != null) {
            List<MethodReader.MethodParam> params = constructor.getParams();
            int size = params.size();
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    writer.append(", ");
                }
                String paramName = params.get(i).name();
                this.constructorFieldNames.add(paramName);
                writer.append(beanReader.constructorParamName(paramName));
            }
        }
        writer.append(");").eol();
    }

    private MethodReader findConstructor() {
        if (this.defaultPublicConstructor || this.publicConstructors.isEmpty()) {
            return null;
        }
        return this.publicConstructors.get(0);
    }
}

