/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.TopPackage;
import io.avaje.jsonb.generator.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

final class ComponentMetaData {
    private final List<String> allTypes = new ArrayList<String>();
    private final List<String> factoryTypes = new ArrayList<String>();
    private String fullName;

    ComponentMetaData() {
    }

    public String toString() {
        return this.allTypes.toString();
    }

    void initialiseFullName() {
        this.fullName();
    }

    boolean contains(String type) {
        return this.allTypes.contains(type);
    }

    void add(String type) {
        this.allTypes.add(type);
    }

    void addFactory(String fullName) {
        this.factoryTypes.add(fullName);
    }

    void setFullName(String fullName) {
        this.fullName = fullName;
    }

    String fullName() {
        if (this.fullName == null) {
            Object topPackage = TopPackage.of(this.allTypes);
            if (!((String)topPackage).endsWith(".jsonb")) {
                topPackage = (String)topPackage + ".jsonb";
            }
            this.fullName = (String)topPackage + ".GeneratedJsonComponent";
        }
        return this.fullName;
    }

    String packageName() {
        return Util.packageOf(this.fullName());
    }

    List<String> all() {
        return this.allTypes;
    }

    List<String> allFactories() {
        return this.factoryTypes;
    }

    Collection<String> allImports() {
        TreeSet<String> packageImports = new TreeSet<String>();
        for (String adapterFullName : this.allTypes) {
            packageImports.add(Util.packageOf(adapterFullName) + ".*");
            packageImports.add(Util.baseTypeOfAdapter(adapterFullName));
        }
        return packageImports;
    }
}

