/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.ImportPrism;
import io.avaje.jsonb.generator.JsonPrism;
import io.avaje.jsonb.generator.SubTypePrism;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

final class ProcessingContext {
    private static final ThreadLocal<Ctx> CTX = new ThreadLocal();
    private static int jdkVersion;
    private static boolean previewEnabled;

    private ProcessingContext() {
    }

    static void init(ProcessingEnvironment processingEnv) {
        CTX.set(new Ctx(processingEnv));
        jdkVersion = processingEnv.getSourceVersion().ordinal();
        previewEnabled = jdkVersion >= 13 && ProcessingContext.initPreviewEnabled(processingEnv);
    }

    private static boolean initPreviewEnabled(ProcessingEnvironment processingEnv) {
        try {
            return (Boolean)ProcessingEnvironment.class.getDeclaredMethod("isPreviewEnabled", new Class[0]).invoke((Object)processingEnv, new Object[0]);
        }
        catch (Throwable e) {
            return false;
        }
    }

    static boolean useEnhancedSwitch() {
        return ProcessingContext.jdkVersion() >= 14;
    }

    static int jdkVersion() {
        return jdkVersion;
    }

    public static boolean previewEnabled() {
        return previewEnabled;
    }

    static void logError(Element e, String msg, Object ... args) {
        ProcessingContext.CTX.get().messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    static void logError(String msg, Object ... args) {
        ProcessingContext.CTX.get().messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args));
    }

    static void logWarn(String msg, Object ... args) {
        ProcessingContext.CTX.get().messager.printMessage(Diagnostic.Kind.WARNING, String.format(msg, args));
    }

    static void logNote(String msg, Object ... args) {
        ProcessingContext.CTX.get().messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
    }

    static void logDebug(String msg, Object ... args) {
        ProcessingContext.CTX.get().messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
    }

    static JavaFileObject createWriter(String cls) throws IOException {
        return ProcessingContext.CTX.get().filer.createSourceFile(cls, new Element[0]);
    }

    static FileObject createMetaInfWriterFor(String interfaceType) throws IOException {
        return ProcessingContext.CTX.get().filer.createResource(StandardLocation.CLASS_OUTPUT, "", interfaceType, new Element[0]);
    }

    static boolean isAssignable2Interface(String type, String superType) {
        return type.equals(superType) || ProcessingContext.element(type).getInterfaces().stream().anyMatch(t -> t.toString().contains(superType));
    }

    static TypeElement element(String rawType) {
        return ProcessingContext.CTX.get().elements.getTypeElement(rawType);
    }

    static Element asElement(TypeMirror returnType) {
        return ProcessingContext.CTX.get().types.asElement(returnType);
    }

    static TypeElement asTypeElement(TypeMirror returnType) {
        return (TypeElement)ProcessingContext.asElement(returnType);
    }

    static ProcessingEnvironment env() {
        return ProcessingContext.CTX.get().env;
    }

    static void addImportedPrism(ImportPrism prism, Element element) {
        if (!prism.subtypes().isEmpty() && prism.value().size() > 1) {
            ProcessingContext.logError(element, "subtypes cannot be used when an import annotation imports more than one class", new Object[0]);
            return;
        }
        Map<String, JsonPrism> json = ProcessingContext.CTX.get().importedJsonMap;
        Map<String, List<SubTypePrism>> subtypes = ProcessingContext.CTX.get().importedSubtypeMap;
        prism.value().forEach(m -> {
            String type = m.toString();
            json.put(type, prism.jsonSettings());
            subtypes.put(type, prism.subtypes());
        });
    }

    static Optional<JsonPrism> importedJson(TypeElement type) {
        return Optional.ofNullable(ProcessingContext.CTX.get().importedJsonMap.get(type.asType().toString()));
    }

    static List<SubTypePrism> importedSubtypes(TypeElement type) {
        return ProcessingContext.CTX.get().importedSubtypeMap.getOrDefault(type.asType().toString(), List.of());
    }

    static void clear() {
        CTX.remove();
    }

    private static final class Ctx {
        private final ProcessingEnvironment env;
        private final Messager messager;
        private final Filer filer;
        private final Elements elements;
        private final Types types;
        private final Map<String, JsonPrism> importedJsonMap = new HashMap<String, JsonPrism>();
        private final Map<String, List<SubTypePrism>> importedSubtypeMap = new HashMap<String, List<SubTypePrism>>();

        Ctx(ProcessingEnvironment env) {
            this.env = env;
            this.messager = env.getMessager();
            this.filer = env.getFiler();
            this.elements = env.getElementUtils();
            this.types = env.getTypeUtils();
        }
    }
}

