/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.Append;
import io.avaje.jsonb.generator.GenericType;
import io.avaje.jsonb.generator.MethodReader;
import io.avaje.jsonb.generator.PrimitiveUtil;
import io.avaje.jsonb.generator.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.type.TypeMirror;

final class FieldProperty {
    private final boolean raw;
    private final boolean unmapped;
    private final String rawType;
    private final boolean publicField;
    private final String fieldName;
    private final List<String> genericTypeParams;
    private final GenericType genericType;
    private final String adapterFieldName;
    private final String adapterShortType;
    private final String defaultValue;
    private final boolean optional;
    private boolean genericTypeParameter;
    private int genericTypeParamPosition;
    private boolean constructorParam;
    private int position;
    private MethodReader getter;
    private MethodReader setter;

    FieldProperty(MethodReader methodReader) {
        this(methodReader.returnType(), false, false, new ArrayList<String>(), false, methodReader.getName());
    }

    FieldProperty(TypeMirror asType, boolean raw, boolean unmapped, List<String> genericTypeParams, boolean publicField, String fieldName) {
        this.raw = raw;
        this.unmapped = unmapped;
        this.publicField = publicField;
        this.fieldName = fieldName;
        this.rawType = Util.trimAnnotations(asType.toString());
        this.optional = this.rawType.startsWith("java.util.Optional");
        this.genericTypeParams = genericTypeParams;
        if (raw) {
            this.genericType = GenericType.parse("java.lang.String");
            this.adapterShortType = "JsonAdapter<String>";
            this.adapterFieldName = "rawAdapter";
            this.defaultValue = "null";
        } else if (unmapped) {
            this.genericType = GenericType.parse("java.lang.Object");
            this.adapterShortType = "JsonAdapter<Object>";
            this.adapterFieldName = "objectJsonAdapter";
            this.defaultValue = "null";
        } else {
            this.genericType = GenericType.parse(this.rawType);
            String shortType = this.genericType.shortType();
            boolean primitive = PrimitiveUtil.isPrimitive(shortType);
            this.defaultValue = !primitive ? "null" : PrimitiveUtil.defaultValue(shortType);
            this.adapterShortType = this.initAdapterShortType(shortType);
            this.adapterFieldName = (primitive && !this.optional ? "p" : "") + this.initShortName();
        }
    }

    void setConstructorParam() {
        this.constructorParam = true;
    }

    void setPosition(int pos) {
        this.position = pos;
    }

    void setGetterMethod(MethodReader getter) {
        this.getter = getter;
    }

    void setSetterMethod(MethodReader setter) {
        this.setter = setter;
    }

    public MethodReader setter() {
        return this.setter;
    }

    boolean isConstructorParam() {
        return this.constructorParam;
    }

    boolean isPublicField() {
        return this.publicField;
    }

    String rawType() {
        return this.rawType;
    }

    String fieldName() {
        return this.fieldName;
    }

    String adapterFieldName() {
        return this.adapterFieldName;
    }

    GenericType genericType() {
        return this.genericType;
    }

    String shortType() {
        return this.genericType.shortType();
    }

    private String initAdapterShortType(String shortType) {
        Object typeWrapped = "JsonAdapter<" + PrimitiveUtil.wrap(shortType) + ">";
        for (int i = 0; i < this.genericTypeParams.size(); ++i) {
            String typeParam = this.genericTypeParams.get(i);
            if (!((String)typeWrapped).contains("<" + typeParam + ">")) continue;
            this.genericTypeParameter = true;
            this.genericTypeParamPosition = i;
            typeWrapped = ((String)typeWrapped).replace("<" + typeParam + ">", "<Object>");
        }
        return typeWrapped;
    }

    private String initShortName() {
        if (this.genericTypeParameter) {
            String name = this.genericType.shortName();
            return Util.initLower(name) + "JsonAdapterGeneric";
        }
        return Util.initLower(this.genericType.shortName()) + "JsonAdapter";
    }

    String typeParamToObject(String shortType) {
        for (String typeParam : this.genericTypeParams) {
            if (!shortType.contains("<" + typeParam + ">")) continue;
            shortType = shortType.replace("<" + typeParam + ">", "<Object>");
        }
        return shortType;
    }

    boolean typeObjectBooleanWithIsPrefix() {
        return this.nameHasIsPrefix() && this.isObjectBoolean();
    }

    boolean typeBooleanWithIsPrefix() {
        return this.nameHasIsPrefix() && this.isBoolean();
    }

    private boolean isObjectBoolean() {
        return "java.lang.Boolean".equals(this.genericType.topType());
    }

    private boolean isBoolean() {
        return "boolean".equals(this.genericType.topType()) || "java.lang.Boolean".equals(this.genericType.topType());
    }

    private boolean nameHasIsPrefix() {
        return this.fieldName.length() > 2 && this.fieldName.startsWith("is") && Character.isUpperCase(this.fieldName.charAt(2));
    }

    void addImports(Set<String> importTypes) {
        if (this.unmapped) {
            importTypes.add("java.util.*");
        }
        if (!this.raw) {
            this.genericType.addImports(importTypes);
        }
    }

    void cascadeTypes(Set<String> types) {
        if (!this.raw && !this.unmapped) {
            String topType = this.genericType.topType();
            if ("java.util.List".equals(topType) || "java.util.Set".equals(topType)) {
                types.add(this.genericType.firstParamType());
            } else if ("java.util.Map".equals(topType)) {
                types.add(this.genericType.firstParamType());
                types.add(this.genericType.secondParamType());
            } else {
                types.add(topType);
            }
        }
    }

    void writeField(Append writer) {
        writer.append("  private final %s %s;", this.adapterShortType, this.adapterFieldName).eol();
    }

    void writeConstructor(Append writer) {
        if (this.raw) {
            writer.append("    this.%s = jsonb.rawAdapter();", this.adapterFieldName).eol();
        } else {
            writer.append("    this.%s = jsonb.adapter(%s);", this.adapterFieldName, this.asTypeDeclaration()).eol();
        }
    }

    private String asTypeDeclaration() {
        String asType = this.genericType.asTypeDeclaration().replace("? extends ", "");
        if (this.genericTypeParameter) {
            return this.genericTypeReplacement(asType, "param" + this.genericTypeParamPosition);
        }
        return asType;
    }

    private String genericTypeReplacement(String asType, String replaceWith) {
        String typeParam = this.genericTypeParams.get(this.genericTypeParamPosition);
        return asType.replace(typeParam + ".class", replaceWith);
    }

    void writeToJson(Append writer, String varName, String prefix) {
        if (this.unmapped) {
            writer.append("%sMap<String, Object> unmapped = ", prefix);
            this.writeGetValue(writer, varName, ";");
            writer.eol();
            writer.append("%sif (unmapped != null) {", prefix).eol();
            writer.append("%s for (Map.Entry<String, Object> entry : unmapped.entrySet()) {", prefix).eol();
            writer.append("%s   writer.name(entry.getKey());", prefix).eol();
            writer.append("%s   objectJsonAdapter.toJson(writer, entry.getValue());", prefix).eol();
            writer.append("%s }", prefix).eol();
            writer.append("%s}", prefix).eol();
        } else {
            writer.append("%swriter.name(%s);", prefix, this.position).eol();
            writer.append("%s%s.toJson(writer, ", prefix, this.adapterFieldName);
            this.writeGetValue(writer, varName, ");");
            writer.eol();
        }
    }

    private void writeGetValue(Append writer, String varName, String suffix) {
        if (this.getter != null) {
            writer.append("%s.%s()%s", varName, this.getter.getName(), suffix);
        } else if (this.publicField) {
            writer.append("%s.%s%s", varName, this.fieldName, suffix);
        } else {
            throw new IllegalStateException("Field " + this.fieldName + " is inaccessible. Add a getter or make the field public.");
        }
    }

    void writeFromJsonVariables(Append writer, String num) {
        if (this.unmapped) {
            return;
        }
        String shortType = this.typeParamToObject(this.genericType.shortType());
        writer.append("    %s _val$%s = %s;", this.pad(shortType), this.fieldName + num, this.defaultValue);
        if (!this.constructorParam && !this.optional) {
            writer.append(" boolean _set$%s = false;", this.fieldName + num);
        }
        writer.eol();
    }

    void writeFromJsonVariablesRecord(Append writer, String num) {
        String type = this.genericTypeParameter ? "Object" : this.genericType.shortType();
        writer.append("    %s _val$%s = %s;", this.pad(type), this.fieldName + num, this.defaultValue).eol();
    }

    private String pad(String value) {
        int pad = 10 - value.length();
        if (pad < 1) {
            return value;
        }
        return value + " ".repeat(pad);
    }

    void writeViewBuilder(Append writer, String shortName, String propertyName) {
        if (this.getter == null) {
            writer.append("    builder.add(\"%s\", %s, builder.field(%s.class, \"%s\"));", propertyName, this.adapterFieldName, shortName, this.fieldName).eol();
        } else {
            Object topType = this.genericType.topType() + ".class";
            if (this.genericTypeParameter) {
                topType = this.genericTypeReplacement((String)topType, "Object.class");
            }
            writer.append("    builder.add(\"%s\", %s, builder.method(%s.class, \"%s\", %s));", propertyName, this.adapterFieldName, shortName, this.getter.getName(), topType).eol();
        }
    }

    void writeFromJsonSetter(Append writer, String varName, String prefix, String num) {
        if (this.unmapped) {
            this.writeFromJsonUnmapped(writer, varName);
            return;
        }
        if (this.setter != null && this.optional) {
            writer.append("%s    _$%s.%s(_val$%s);", prefix, varName, this.setter.getName(), this.fieldName + num).eol();
        } else if (this.setter != null) {
            writer.append("%s    if (_set$%s) _$%s.%s(_val$%s);", prefix, this.fieldName + num, varName, this.setter.getName(), this.fieldName + num).eol();
        } else if (this.publicField) {
            writer.append("%s    if (_set$%s) _$%s.%s = _val$%s;", prefix, this.fieldName + num, varName, this.fieldName, this.fieldName + num).eol();
        }
    }

    void writeFromJsonUnmapped(Append writer, String varName) {
        if (this.setter != null) {
            writer.append("    _$%s.%s(unmapped);", varName, this.setter.getName()).eol();
        } else if (this.publicField) {
            writer.append("    _$%s.%s = unmapped;", varName, this.fieldName).eol();
        }
    }

    public void writeFromJsonSwitch(Append writer, String varName, boolean defaultConstructor) {
        if (defaultConstructor) {
            if (this.setter != null) {
                writer.append("          _$%s.%s(%s.fromJson(reader));", varName, this.setter.getName(), this.adapterFieldName);
            } else if (this.publicField) {
                writer.append("          _$%s.%s = %s.fromJson(reader);", varName, this.fieldName, this.adapterFieldName);
            }
        } else {
            writer.append("          _val$%s = %s.fromJson(reader);", this.fieldName, this.adapterFieldName);
            if (!this.constructorParam && !this.optional) {
                writer.eol().append("          _set$%s = true;", this.fieldName);
            }
        }
    }
}

