/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.APContext;
import io.avaje.jsonb.generator.ComponentMetaData;
import io.avaje.jsonb.generator.FactoryPrism;
import io.avaje.jsonb.generator.MetaDataPrism;
import java.io.FileNotFoundException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

final class ComponentReader {
    private final ComponentMetaData componentMetaData;

    ComponentReader(ComponentMetaData metaData) {
        this.componentMetaData = metaData;
    }

    void read() {
        TypeElement moduleType;
        String componentFullName = this.loadMetaInfServices();
        if (componentFullName != null && (moduleType = APContext.typeElement(componentFullName)) != null) {
            this.componentMetaData.setFullName(componentFullName);
            this.readMetaData(moduleType);
        }
    }

    private void readMetaData(TypeElement moduleType) {
        for (AnnotationMirror annotationMirror : moduleType.getAnnotationMirrors()) {
            MetaDataPrism metaData = MetaDataPrism.getInstance(annotationMirror);
            FactoryPrism metaDataFactory = FactoryPrism.getInstance(annotationMirror);
            if (metaData != null) {
                metaData.value().stream().map(TypeMirror::toString).forEach(this.componentMetaData::add);
                continue;
            }
            if (metaDataFactory == null) continue;
            metaDataFactory.value().stream().map(TypeMirror::toString).forEach(this.componentMetaData::addFactory);
        }
    }

    private String loadMetaInfServices() {
        List<String> lines = this.loadMetaInf();
        return lines.isEmpty() ? null : lines.get(0);
    }

    private List<String> loadMetaInf() {
        try {
            FileObject fileObject = APContext.processingEnv().getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/io.avaje.jsonb.Jsonb$GeneratedComponent");
            if (fileObject != null) {
                String line;
                ArrayList<String> lines = new ArrayList<String>();
                Reader reader = fileObject.openReader(true);
                LineNumberReader lineReader = new LineNumberReader(reader);
                while ((line = lineReader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    lines.add(line);
                }
                return lines;
            }
        }
        catch (FileNotFoundException | NoSuchFileException fileObject) {
        }
        catch (FilerException e) {
            APContext.logNote("FilerException reading services file", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            APContext.logWarn("Error reading services file: " + e.getMessage(), new Object[0]);
        }
        return Collections.emptyList();
    }
}

