/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.AliasPrism;
import io.avaje.jsonb.generator.Append;
import io.avaje.jsonb.generator.FieldProperty;
import io.avaje.jsonb.generator.GenericType;
import io.avaje.jsonb.generator.JsonAliasPrism;
import io.avaje.jsonb.generator.MethodReader;
import io.avaje.jsonb.generator.NamingConvention;
import io.avaje.jsonb.generator.PropertyIgnoreReader;
import io.avaje.jsonb.generator.PropertyPrism;
import io.avaje.jsonb.generator.TypeSubTypeMeta;
import io.avaje.jsonb.generator.Util;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

final class FieldReader {
    private final Map<String, TypeSubTypeMeta> subTypes = new LinkedHashMap<String, TypeSubTypeMeta>();
    private final FieldProperty property;
    private final String propertyName;
    private final boolean serialize;
    private final boolean deserialize;
    private final boolean unmapped;
    private final boolean raw;
    private final List<String> aliases;
    private boolean isSubTypeField;
    private final String num;

    FieldReader(Element element, NamingConvention namingConvention, TypeSubTypeMeta subType, List<String> genericTypeParams, Integer frequency) {
        this.num = frequency == 0 ? "" : frequency.toString();
        this.addSubType(subType);
        PropertyIgnoreReader ignoreReader = new PropertyIgnoreReader(element);
        this.unmapped = ignoreReader.unmapped();
        boolean isMethod = element instanceof ExecutableElement;
        this.raw = ignoreReader.raw();
        this.serialize = ignoreReader.serialize();
        this.deserialize = !isMethod && ignoreReader.deserialize();
        String fieldName = element.getSimpleName().toString();
        boolean publicField = !isMethod && element.getModifiers().contains((Object)Modifier.PUBLIC);
        TypeMirror type = isMethod ? ((ExecutableElement)element).getReturnType() : element.asType();
        this.property = new FieldProperty(type, this.raw, this.unmapped, genericTypeParams, publicField, fieldName);
        this.propertyName = PropertyPrism.getOptionalOn(element).map(PropertyPrism::value).map(Util::escapeQuotes).orElse(namingConvention.from(fieldName));
        this.aliases = FieldReader.initAliases(element);
    }

    private static List<String> initAliases(Element element) {
        return AliasPrism.getOptionalOn(element).map(a -> Util.escapeQuotes(a.value())).orElse(JsonAliasPrism.getOptionalOn(element).map(a -> Util.escapeQuotes(a.value())).orElse(Collections.emptyList()));
    }

    void position(int pos) {
        this.property.setPosition(pos);
    }

    String fieldName() {
        return this.property.fieldName();
    }

    String propertyName() {
        return this.propertyName;
    }

    boolean typeObjectBooleanWithIsPrefix() {
        return this.property.typeObjectBooleanWithIsPrefix();
    }

    boolean typeBooleanWithIsPrefix() {
        return this.property.typeBooleanWithIsPrefix();
    }

    boolean isRaw() {
        return this.raw;
    }

    boolean isUnmapped() {
        return this.unmapped;
    }

    boolean include() {
        return this.serialize || this.deserialize;
    }

    boolean includeFromJson() {
        return this.deserialize;
    }

    boolean includeToJson() {
        return this.serialize;
    }

    boolean includeToJson(String type) {
        return this.serialize && (type == null || this.subTypes.containsKey(type));
    }

    void addSubType(TypeSubTypeMeta currentSubType) {
        if (currentSubType != null) {
            this.subTypes.put(currentSubType.type(), currentSubType);
        }
    }

    void setSubTypeField() {
        this.isSubTypeField = true;
    }

    boolean isSubTypeField() {
        return this.isSubTypeField;
    }

    boolean includeForType(TypeSubTypeMeta subType) {
        return this.subTypes.containsKey(subType.type());
    }

    void addImports(Set<String> importTypes) {
        this.property.addImports(importTypes);
    }

    void cascadeTypes(Set<String> types) {
        this.property.cascadeTypes(types);
    }

    void setterMethod(MethodReader setter) {
        this.property.setSetterMethod(setter);
    }

    void getterMethod(MethodReader getter) {
        this.property.setGetterMethod(getter);
    }

    void setConstructorParam() {
        this.property.setConstructorParam();
    }

    boolean isPublicField() {
        return this.property.isPublicField();
    }

    void writeDebug(Append writer) {
        writer.append("  // %s [%s] name:%s", this.property.fieldName(), this.property.rawType(), this.propertyName);
        if (!this.serialize) {
            writer.append(" ignoreSerialize");
        }
        if (!this.deserialize) {
            writer.append(" ignoreDeserialize");
        } else if (this.property.isConstructorParam()) {
            writer.append(" constructor");
        } else if (this.property.setter() != null) {
            writer.append(" setter:%s ", this.property.setter());
        } else if (this.property.isPublicField()) {
            writer.append(" publicField");
        } else {
            writer.append(" ERROR?? no constructor, setter and not a public field?");
        }
        if (!this.subTypes.isEmpty()) {
            writer.append(" subTypes %s", this.subTypes.keySet());
        }
        writer.eol();
    }

    String adapterShortType() {
        return this.property.shortType();
    }

    void writeField(Append writer) {
        this.property.writeField(writer);
    }

    void writeConstructor(Append writer) {
        this.property.writeConstructor(writer);
    }

    void writeToJson(Append writer, String varName, String prefix) {
        this.property.writeToJson(writer, varName, prefix);
    }

    void writeFromJsonVariables(Append writer) {
        this.property.writeFromJsonVariables(writer, this.num);
    }

    void writeFromJsonVariablesRecord(Append writer) {
        this.property.writeFromJsonVariablesRecord(writer, this.num);
    }

    void writeFromJsonSwitch(Append writer, boolean defaultConstructor, String varName, boolean caseInsensitiveKeys, List<String> moreAlias) {
        if (this.unmapped) {
            return;
        }
        this.aliases.addAll(moreAlias);
        for (String alias : this.aliases) {
            String propertyKey = caseInsensitiveKeys ? alias.toLowerCase() : alias;
            writer.append("        case \"%s\":", propertyKey).eol();
        }
        String propertyKey = caseInsensitiveKeys ? this.propertyName.toLowerCase() : this.propertyName;
        writer.append("        case \"%s\": ", propertyKey).eol();
        if (!this.deserialize) {
            writer.append("          reader.skipValue();");
        } else {
            this.property.writeFromJsonSwitch(writer, varName, defaultConstructor);
        }
        writer.eol().append("          break;").eol().eol();
    }

    void writeFromJsonSetter(Append writer, String varName, String prefix) {
        this.property.writeFromJsonSetter(writer, varName, prefix, this.num);
    }

    void writeFromJsonUnmapped(Append writer, String varName) {
        this.property.writeFromJsonUnmapped(writer, varName);
    }

    void writeViewBuilder(Append writer, String shortName) {
        this.property.writeViewBuilder(writer, shortName, this.propertyName);
    }

    public String toString() {
        return this.property.fieldName();
    }

    public GenericType type() {
        return this.property.genericType();
    }

    public boolean isConstructorParam() {
        return this.property.isConstructorParam();
    }

    public String fieldNameWithNum() {
        return this.property.fieldName() + this.num;
    }

    public String adapterFieldName() {
        return this.property.adapterFieldName();
    }

    public MethodReader setter() {
        return this.property.setter();
    }

    public void setSetter(MethodReader setter) {
        this.property.setSetterMethod(setter);
    }

    public boolean isDeserialize() {
        return this.deserialize;
    }

    public Map<String, TypeSubTypeMeta> subTypes() {
        return this.subTypes;
    }

    public List<String> aliases() {
        return this.aliases;
    }
}

